/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.page.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class Viewport {
    private final Number x;
    private final Number y;
    private final Number width;
    private final Number height;
    private final Number scale;

    public Viewport(Number x, Number y, Number width, Number height, Number scale) {
        this.x = Objects.requireNonNull(x, "x is required");
        this.y = Objects.requireNonNull(y, "y is required");
        this.width = Objects.requireNonNull(width, "width is required");
        this.height = Objects.requireNonNull(height, "height is required");
        this.scale = Objects.requireNonNull(scale, "scale is required");
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public Number getWidth() {
        return this.width;
    }

    public Number getHeight() {
        return this.height;
    }

    public Number getScale() {
        return this.scale;
    }

    private static Viewport fromJson(JsonInput input) {
        Number x = 0;
        Number y = 0;
        Number width = 0;
        Number height = 0;
        Number scale = 0;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "x": {
                    x = input.nextNumber();
                    continue block14;
                }
                case "y": {
                    y = input.nextNumber();
                    continue block14;
                }
                case "width": {
                    width = input.nextNumber();
                    continue block14;
                }
                case "height": {
                    height = input.nextNumber();
                    continue block14;
                }
                case "scale": {
                    scale = input.nextNumber();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Viewport(x, y, width, height, scale);
    }
}

