package org.openqa.selenium.devtools.v141.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about uses of APIs that may be considered misuse to
 * re-identify users.
 */
public class UserReidentificationIssueDetails {

    private final org.openqa.selenium.devtools.v141.audits.model.UserReidentificationIssueType type;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.AffectedRequest> request;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.SourceCodeLocation> sourceCodeLocation;

    public UserReidentificationIssueDetails(org.openqa.selenium.devtools.v141.audits.model.UserReidentificationIssueType type, java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.AffectedRequest> request, java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.SourceCodeLocation> sourceCodeLocation) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.request = request;
        this.sourceCodeLocation = sourceCodeLocation;
    }

    public org.openqa.selenium.devtools.v141.audits.model.UserReidentificationIssueType getType() {
        return type;
    }

    /**
     * Applies to BlockedFrameNavigation and BlockedSubresource issue types.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.AffectedRequest> getRequest() {
        return request;
    }

    /**
     * Applies to NoisedCanvasReadback issue type.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.SourceCodeLocation> getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    private static UserReidentificationIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.audits.model.UserReidentificationIssueType type = null;
        java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.AffectedRequest> request = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v141.audits.model.SourceCodeLocation> sourceCodeLocation = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v141.audits.model.UserReidentificationIssueType.class);
                    break;
                case "request":
                    request = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.audits.model.AffectedRequest.class));
                    break;
                case "sourceCodeLocation":
                    sourceCodeLocation = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.audits.model.SourceCodeLocation.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new UserReidentificationIssueDetails(type, request, sourceCodeLocation);
    }
}
