package org.openqa.selenium.devtools.v141.filesystem.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class BucketFileSystemLocator {

    private final org.openqa.selenium.devtools.v141.storage.model.SerializedStorageKey storageKey;

    private final java.util.Optional<java.lang.String> bucketName;

    private final java.util.List<java.lang.String> pathComponents;

    public BucketFileSystemLocator(org.openqa.selenium.devtools.v141.storage.model.SerializedStorageKey storageKey, java.util.Optional<java.lang.String> bucketName, java.util.List<java.lang.String> pathComponents) {
        this.storageKey = java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        this.bucketName = bucketName;
        this.pathComponents = java.util.Objects.requireNonNull(pathComponents, "pathComponents is required");
    }

    /**
     * Storage key
     */
    public org.openqa.selenium.devtools.v141.storage.model.SerializedStorageKey getStorageKey() {
        return storageKey;
    }

    /**
     * Bucket name. Not passing a `bucketName` will retrieve the default Bucket. (https://developer.mozilla.org/en-US/docs/Web/API/Storage_API#storage_buckets)
     */
    public java.util.Optional<java.lang.String> getBucketName() {
        return bucketName;
    }

    /**
     * Path to the directory using each path component as an array item.
     */
    public java.util.List<java.lang.String> getPathComponents() {
        return pathComponents;
    }

    private static BucketFileSystemLocator fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.storage.model.SerializedStorageKey storageKey = null;
        java.util.Optional<java.lang.String> bucketName = java.util.Optional.empty();
        java.util.List<java.lang.String> pathComponents = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "storageKey":
                    storageKey = input.read(org.openqa.selenium.devtools.v141.storage.model.SerializedStorageKey.class);
                    break;
                case "bucketName":
                    bucketName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "pathComponents":
                    pathComponents = input.readArray(java.lang.String.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BucketFileSystemLocator(storageKey, bucketName, pathComponents);
    }
}
