package org.openqa.selenium.devtools.v142.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class WorkAreaInsets {

    private final java.util.Optional<java.lang.Integer> top;

    private final java.util.Optional<java.lang.Integer> left;

    private final java.util.Optional<java.lang.Integer> bottom;

    private final java.util.Optional<java.lang.Integer> right;

    public WorkAreaInsets(java.util.Optional<java.lang.Integer> top, java.util.Optional<java.lang.Integer> left, java.util.Optional<java.lang.Integer> bottom, java.util.Optional<java.lang.Integer> right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    /**
     * Work area top inset in pixels. Default is 0;
     */
    public java.util.Optional<java.lang.Integer> getTop() {
        return top;
    }

    /**
     * Work area left inset in pixels. Default is 0;
     */
    public java.util.Optional<java.lang.Integer> getLeft() {
        return left;
    }

    /**
     * Work area bottom inset in pixels. Default is 0;
     */
    public java.util.Optional<java.lang.Integer> getBottom() {
        return bottom;
    }

    /**
     * Work area right inset in pixels. Default is 0;
     */
    public java.util.Optional<java.lang.Integer> getRight() {
        return right;
    }

    private static WorkAreaInsets fromJson(JsonInput input) {
        java.util.Optional<java.lang.Integer> top = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> left = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> bottom = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> right = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "top":
                    top = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "left":
                    left = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "bottom":
                    bottom = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "right":
                    right = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WorkAreaInsets(top, left, bottom, right);
    }
}
