/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.domsnapshot.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v142.domsnapshot.model.LayoutTreeSnapshot;
import org.openqa.selenium.devtools.v142.domsnapshot.model.NodeTreeSnapshot;
import org.openqa.selenium.devtools.v142.domsnapshot.model.StringIndex;
import org.openqa.selenium.devtools.v142.domsnapshot.model.TextBoxSnapshot;
import org.openqa.selenium.json.JsonInput;

public class DocumentSnapshot {
    private final StringIndex documentURL;
    private final StringIndex title;
    private final StringIndex baseURL;
    private final StringIndex contentLanguage;
    private final StringIndex encodingName;
    private final StringIndex publicId;
    private final StringIndex systemId;
    private final StringIndex frameId;
    private final NodeTreeSnapshot nodes;
    private final LayoutTreeSnapshot layout;
    private final TextBoxSnapshot textBoxes;
    private final Optional<Number> scrollOffsetX;
    private final Optional<Number> scrollOffsetY;
    private final Optional<Number> contentWidth;
    private final Optional<Number> contentHeight;

    public DocumentSnapshot(StringIndex documentURL, StringIndex title, StringIndex baseURL, StringIndex contentLanguage, StringIndex encodingName, StringIndex publicId, StringIndex systemId, StringIndex frameId, NodeTreeSnapshot nodes, LayoutTreeSnapshot layout, TextBoxSnapshot textBoxes, Optional<Number> scrollOffsetX, Optional<Number> scrollOffsetY, Optional<Number> contentWidth, Optional<Number> contentHeight) {
        this.documentURL = Objects.requireNonNull(documentURL, "documentURL is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.baseURL = Objects.requireNonNull(baseURL, "baseURL is required");
        this.contentLanguage = Objects.requireNonNull(contentLanguage, "contentLanguage is required");
        this.encodingName = Objects.requireNonNull(encodingName, "encodingName is required");
        this.publicId = Objects.requireNonNull(publicId, "publicId is required");
        this.systemId = Objects.requireNonNull(systemId, "systemId is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.nodes = Objects.requireNonNull(nodes, "nodes is required");
        this.layout = Objects.requireNonNull(layout, "layout is required");
        this.textBoxes = Objects.requireNonNull(textBoxes, "textBoxes is required");
        this.scrollOffsetX = scrollOffsetX;
        this.scrollOffsetY = scrollOffsetY;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    public StringIndex getDocumentURL() {
        return this.documentURL;
    }

    public StringIndex getTitle() {
        return this.title;
    }

    public StringIndex getBaseURL() {
        return this.baseURL;
    }

    public StringIndex getContentLanguage() {
        return this.contentLanguage;
    }

    public StringIndex getEncodingName() {
        return this.encodingName;
    }

    public StringIndex getPublicId() {
        return this.publicId;
    }

    public StringIndex getSystemId() {
        return this.systemId;
    }

    public StringIndex getFrameId() {
        return this.frameId;
    }

    public NodeTreeSnapshot getNodes() {
        return this.nodes;
    }

    public LayoutTreeSnapshot getLayout() {
        return this.layout;
    }

    public TextBoxSnapshot getTextBoxes() {
        return this.textBoxes;
    }

    public Optional<Number> getScrollOffsetX() {
        return this.scrollOffsetX;
    }

    public Optional<Number> getScrollOffsetY() {
        return this.scrollOffsetY;
    }

    public Optional<Number> getContentWidth() {
        return this.contentWidth;
    }

    public Optional<Number> getContentHeight() {
        return this.contentHeight;
    }

    private static DocumentSnapshot fromJson(JsonInput input) {
        StringIndex documentURL = null;
        StringIndex title = null;
        StringIndex baseURL = null;
        StringIndex contentLanguage = null;
        StringIndex encodingName = null;
        StringIndex publicId = null;
        StringIndex systemId = null;
        StringIndex frameId = null;
        NodeTreeSnapshot nodes = null;
        LayoutTreeSnapshot layout = null;
        TextBoxSnapshot textBoxes = null;
        Optional<Number> scrollOffsetX = Optional.empty();
        Optional<Number> scrollOffsetY = Optional.empty();
        Optional<Number> contentWidth = Optional.empty();
        Optional<Number> contentHeight = Optional.empty();
        input.beginObject();
        block34: while (input.hasNext()) {
            switch (input.nextName()) {
                case "documentURL": {
                    documentURL = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "title": {
                    title = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "baseURL": {
                    baseURL = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "contentLanguage": {
                    contentLanguage = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "encodingName": {
                    encodingName = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "publicId": {
                    publicId = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "systemId": {
                    systemId = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "frameId": {
                    frameId = (StringIndex)input.read(StringIndex.class);
                    continue block34;
                }
                case "nodes": {
                    nodes = (NodeTreeSnapshot)input.read(NodeTreeSnapshot.class);
                    continue block34;
                }
                case "layout": {
                    layout = (LayoutTreeSnapshot)input.read(LayoutTreeSnapshot.class);
                    continue block34;
                }
                case "textBoxes": {
                    textBoxes = (TextBoxSnapshot)input.read(TextBoxSnapshot.class);
                    continue block34;
                }
                case "scrollOffsetX": {
                    scrollOffsetX = Optional.ofNullable(input.nextNumber());
                    continue block34;
                }
                case "scrollOffsetY": {
                    scrollOffsetY = Optional.ofNullable(input.nextNumber());
                    continue block34;
                }
                case "contentWidth": {
                    contentWidth = Optional.ofNullable(input.nextNumber());
                    continue block34;
                }
                case "contentHeight": {
                    contentHeight = Optional.ofNullable(input.nextNumber());
                    continue block34;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DocumentSnapshot(documentURL, title, baseURL, contentLanguage, encodingName, publicId, systemId, frameId, nodes, layout, textBoxes, scrollOffsetX, scrollOffsetY, contentWidth, contentHeight);
    }
}

