/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.storage.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class TrustTokens {
    private final String issuerOrigin;
    private final Number count;

    public TrustTokens(String issuerOrigin, Number count) {
        this.issuerOrigin = Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        this.count = Objects.requireNonNull(count, "count is required");
    }

    public String getIssuerOrigin() {
        return this.issuerOrigin;
    }

    public Number getCount() {
        return this.count;
    }

    private static TrustTokens fromJson(JsonInput input) {
        String issuerOrigin = null;
        Number count = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "issuerOrigin": {
                    issuerOrigin = input.nextString();
                    continue block8;
                }
                case "count": {
                    count = input.nextNumber();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TrustTokens(issuerOrigin, count);
    }
}

