package org.openqa.selenium.devtools.v85.accessibility.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A node in the accessibility tree.
 */
public class AXNode {

    private final org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId nodeId;

    private final java.lang.Boolean ignored;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> ignoredReasons;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> role;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> name;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> description;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> value;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> properties;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId>> childIds;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.BackendNodeId> backendDOMNodeId;

    public AXNode(org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId nodeId, java.lang.Boolean ignored, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> ignoredReasons, java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> role, java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> name, java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> description, java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> value, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> properties, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId>> childIds, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.BackendNodeId> backendDOMNodeId) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.ignored = java.util.Objects.requireNonNull(ignored, "ignored is required");
        this.ignoredReasons = ignoredReasons;
        this.role = role;
        this.name = name;
        this.description = description;
        this.value = value;
        this.properties = properties;
        this.childIds = childIds;
        this.backendDOMNodeId = backendDOMNodeId;
    }

    /**
     * Unique identifier for this node.
     */
    public org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId getNodeId() {
        return nodeId;
    }

    /**
     * Whether this node is ignored for accessibility
     */
    public java.lang.Boolean getIgnored() {
        return ignored;
    }

    /**
     * Collection of reasons why this node is hidden.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> getIgnoredReasons() {
        return ignoredReasons;
    }

    /**
     * This `Node`'s role, whether explicit or implicit.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> getRole() {
        return role;
    }

    /**
     * The accessible name for this `Node`.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> getName() {
        return name;
    }

    /**
     * The accessible description for this `Node`.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> getDescription() {
        return description;
    }

    /**
     * The value for this `Node`.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> getValue() {
        return value;
    }

    /**
     * All other properties
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> getProperties() {
        return properties;
    }

    /**
     * IDs for each of this node's child nodes.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId>> getChildIds() {
        return childIds;
    }

    /**
     * The backend ID for the associated DOM node, if any.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.BackendNodeId> getBackendDOMNodeId() {
        return backendDOMNodeId;
    }

    private static AXNode fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId nodeId = null;
        java.lang.Boolean ignored = false;
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> ignoredReasons = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> role = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> name = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> description = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.accessibility.model.AXValue> value = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>> properties = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId>> childIds = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.BackendNodeId> backendDOMNodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId.class);
                    break;
                case "ignored":
                    ignored = input.nextBoolean();
                    break;
                case "ignoredReasons":
                    ignoredReasons = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>>() {
                    }.getType()));
                    break;
                case "role":
                    role = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.accessibility.model.AXValue.class));
                    break;
                case "name":
                    name = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.accessibility.model.AXValue.class));
                    break;
                case "description":
                    description = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.accessibility.model.AXValue.class));
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.accessibility.model.AXValue.class));
                    break;
                case "properties":
                    properties = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXProperty>>() {
                    }.getType()));
                    break;
                case "childIds":
                    childIds = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId>>() {
                    }.getType()));
                    break;
                case "backendDOMNodeId":
                    backendDOMNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AXNode(nodeId, ignored, ignoredReasons, role, name, description, value, properties, childIds, backendDOMNodeId);
    }
}
