/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v99.audits.model.GenericIssueErrorType;
import org.openqa.selenium.devtools.v99.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class GenericIssueDetails {
    private final GenericIssueErrorType errorType;
    private final Optional<FrameId> frameId;

    public GenericIssueDetails(GenericIssueErrorType errorType, Optional<FrameId> frameId) {
        this.errorType = Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
    }

    public GenericIssueErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        GenericIssueErrorType errorType = null;
        Optional<FrameId> frameId = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "errorType": {
                    errorType = (GenericIssueErrorType)((Object)input.read(GenericIssueErrorType.class));
                    continue block8;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId);
    }
}

