/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.ProfilesIni;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.Browser;

public class FirefoxOptions
extends AbstractDriverOptions<FirefoxOptions> {
    public static final String FIREFOX_OPTIONS = "moz:firefoxOptions";
    private Map<String, Object> firefoxOptions = Collections.unmodifiableMap(new TreeMap());

    public FirefoxOptions() {
        this.setCapability("browserName", Browser.FIREFOX.browserName());
        this.setAcceptInsecureCerts(true);
        this.addPreference("remote.active-protocols", 1);
    }

    public FirefoxOptions(Capabilities source) {
        this();
        source.getCapabilityNames().stream().filter(name -> !FIREFOX_OPTIONS.equals(name)).forEach(name -> {
            Object value = source.getCapability(name);
            if (value != null) {
                this.setCapability((String)name, value);
            }
        });
        if (source instanceof FirefoxOptions) {
            this.mirror((FirefoxOptions)source);
        } else {
            Object rawOptions = source.getCapability(FIREFOX_OPTIONS);
            if (rawOptions != null) {
                Require.stateCondition((boolean)(rawOptions instanceof Map), (String)"Expected options to be a map: %s", (Object[])new Object[]{rawOptions});
                Map sourceOptions = (Map)rawOptions;
                TreeMap<String, Object> options = new TreeMap<String, Object>();
                for (Keys key : Keys.values()) {
                    key.amend(sourceOptions, options);
                }
                this.firefoxOptions = Collections.unmodifiableMap(options);
            }
        }
    }

    private void mirror(FirefoxOptions that) {
        TreeMap<String, Object> newOptions = new TreeMap<String, Object>(this.firefoxOptions);
        for (Keys key : Keys.values()) {
            Object value = key.mirror(this.firefoxOptions, that.firefoxOptions);
            if (value == null) continue;
            newOptions.put(key.key(), value);
        }
        this.firefoxOptions = Collections.unmodifiableMap(newOptions);
    }

    public FirefoxOptions configureFromEnv() {
        String profileName;
        String binary = System.getProperty("webdriver.firefox.bin");
        if (binary != null) {
            this.setBinary(binary);
        }
        if ((profileName = System.getProperty("webdriver.firefox.profile")) != null) {
            FirefoxProfile profile = new ProfilesIni().getProfile(profileName);
            if (profile == null) {
                throw new WebDriverException(String.format("Firefox profile '%s' named in system property '%s' not found", profileName, "webdriver.firefox.profile"));
            }
            this.setProfile(profile);
        }
        return this;
    }

    public FirefoxOptions setBinary(Path path) {
        Require.nonNull((String)"Binary", (Object)path);
        return this.setFirefoxOption(Keys.BINARY, (Object)path.toString());
    }

    public FirefoxOptions setBinary(String path) {
        Require.nonNull((String)"Binary", (Object)path);
        return this.setFirefoxOption(Keys.BINARY, (Object)path);
    }

    public FirefoxProfile getProfile() {
        Object rawProfile = this.firefoxOptions.get(Keys.PROFILE.key());
        if (rawProfile == null) {
            return new FirefoxProfile();
        }
        if (rawProfile instanceof FirefoxProfile) {
            return (FirefoxProfile)rawProfile;
        }
        try {
            return FirefoxProfile.fromJson((String)rawProfile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FirefoxOptions setProfile(FirefoxProfile profile) {
        Require.nonNull((String)"Profile", (Object)profile);
        try {
            return this.setFirefoxOption(Keys.PROFILE, (Object)profile.toJson());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FirefoxOptions addArguments(String ... arguments) {
        this.addArguments(Arrays.asList(arguments));
        return this;
    }

    public FirefoxOptions addArguments(List<String> arguments) {
        Require.nonNull((String)"Arguments", arguments);
        ArrayList rawList = this.firefoxOptions.getOrDefault(Keys.ARGS.key(), new ArrayList());
        Require.stateCondition((boolean)(rawList instanceof List), (String)"Arg list of unexpected type: %s", (Object[])new Object[]{rawList});
        ArrayList<String> newArgs = new ArrayList<String>();
        ((List)rawList).stream().map(String::valueOf).forEach(newArgs::add);
        newArgs.addAll(arguments);
        return this.setFirefoxOption(Keys.ARGS, Collections.unmodifiableList(newArgs));
    }

    public FirefoxOptions addPreference(String key, Object value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        HashMap rawPrefs = this.firefoxOptions.getOrDefault(Keys.PREFS.key(), new HashMap());
        Require.stateCondition((boolean)(rawPrefs instanceof Map), (String)"Prefs are of unexpected type: %s", (Object[])new Object[]{rawPrefs});
        Map prefs = rawPrefs;
        TreeMap<String, Object> newPrefs = new TreeMap<String, Object>(prefs);
        newPrefs.put(key, value);
        return this.setFirefoxOption(Keys.PREFS, Collections.unmodifiableMap(newPrefs));
    }

    public FirefoxOptions setLogLevel(FirefoxDriverLogLevel logLevel) {
        Require.nonNull((String)"Log level", (Object)((Object)logLevel));
        return this.setFirefoxOption(Keys.LOG, logLevel.toJson());
    }

    public FirefoxOptions setAndroidPackage(String androidPackage) {
        Require.nonNull((String)"Android package", (Object)androidPackage);
        return this.setFirefoxOption("androidPackage", (Object)androidPackage);
    }

    public FirefoxOptions setAndroidActivity(String activity) {
        Require.nonNull((String)"Android activity", (Object)activity);
        return this.setFirefoxOption("androidActivity", (Object)activity);
    }

    public FirefoxOptions setAndroidDeviceSerialNumber(String serial) {
        Require.nonNull((String)"Android device serial number", (Object)serial);
        return this.setFirefoxOption("androidDeviceSerial", (Object)serial);
    }

    public FirefoxOptions setAndroidIntentArguments(String[] args) {
        Require.nonNull((String)"Android intent arguments", (Object)args);
        return this.setAndroidIntentArguments(Arrays.asList(args));
    }

    public FirefoxOptions setAndroidIntentArguments(List<String> args) {
        Require.nonNull((String)"Android intent arguments", args);
        return this.setFirefoxOption("androidIntentArguments", args);
    }

    private FirefoxOptions setFirefoxOption(Keys key, Object value) {
        return this.setFirefoxOption(key.key(), value);
    }

    private FirefoxOptions setFirefoxOption(String key, Object value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        TreeMap<String, Object> newOptions = new TreeMap<String, Object>(this.firefoxOptions);
        newOptions.put(key, value);
        this.firefoxOptions = Collections.unmodifiableMap(newOptions);
        return this;
    }

    public FirefoxOptions enableBiDi() {
        this.setCapability("webSocketUrl", true);
        return this;
    }

    protected Set<String> getExtraCapabilityNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.add(FIREFOX_OPTIONS);
        return Collections.unmodifiableSet(names);
    }

    protected Object getExtraCapability(String capabilityName) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        if (FIREFOX_OPTIONS.equals(capabilityName)) {
            return Collections.unmodifiableMap(this.firefoxOptions);
        }
        return null;
    }

    public FirefoxOptions merge(Capabilities capabilities) {
        List arguments;
        Require.nonNull((String)"Capabilities to merge", (Object)capabilities);
        FirefoxOptions newInstance = new FirefoxOptions();
        this.getCapabilityNames().forEach(name -> newInstance.setCapability((String)name, this.getCapability((String)name)));
        newInstance.mirror(this);
        for (String name2 : capabilities.getCapabilityNames()) {
            Map logLevelMap;
            FirefoxDriverLogLevel logLevel;
            if (!(name2.equals(Keys.ARGS.key) || name2.equals(Keys.PREFS.key) || name2.equals(Keys.PROFILE.key) || name2.equals(Keys.BINARY.key) || name2.equals(Keys.LOG.key))) {
                newInstance.setCapability(name2, capabilities.getCapability(name2));
            }
            if (name2.equals(Keys.ARGS.key) && capabilities.getCapability(name2) != null) {
                arguments = (List)capabilities.getCapability("args");
                arguments.forEach(arg -> {
                    if (!((List)newInstance.firefoxOptions.get(Keys.ARGS.key())).contains(arg)) {
                        newInstance.addArguments((String)arg);
                    }
                });
            }
            if (name2.equals(Keys.PREFS.key) && capabilities.getCapability(name2) != null) {
                Map prefs = (Map)capabilities.getCapability("prefs");
                prefs.forEach(newInstance::addPreference);
            }
            if (name2.equals(Keys.PROFILE.key) && capabilities.getCapability(name2) != null) {
                String rawProfile = (String)capabilities.getCapability("profile");
                try {
                    newInstance.setProfile(FirefoxProfile.fromJson(rawProfile));
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            if (name2.equals(Keys.BINARY.key) && capabilities.getCapability(name2) != null) {
                Object binary = capabilities.getCapability("binary");
                if (binary instanceof String) {
                    newInstance.setBinary((String)binary);
                } else if (binary instanceof Path) {
                    newInstance.setBinary((Path)binary);
                }
            }
            if (!name2.equals(Keys.LOG.key) || capabilities.getCapability(name2) == null || (logLevel = FirefoxDriverLogLevel.fromString((String)(logLevelMap = (Map)capabilities.getCapability("log")).get("level"))) == null) continue;
            newInstance.setLogLevel(logLevel);
        }
        if (capabilities instanceof FirefoxOptions) {
            newInstance.mirror((FirefoxOptions)capabilities);
        } else {
            Object optionsValue = capabilities.getCapability(FIREFOX_OPTIONS);
            if (optionsValue instanceof Map) {
                Map options = (Map)optionsValue;
                arguments = options.getOrDefault("args", new ArrayList());
                Map prefs = options.getOrDefault("prefs", new HashMap());
                String rawProfile = (String)options.get("profile");
                Map logLevelMap = options.getOrDefault("log", new HashMap());
                FirefoxDriverLogLevel logLevel = FirefoxDriverLogLevel.fromString((String)logLevelMap.get("level"));
                arguments.forEach(arg -> {
                    if (!((List)newInstance.firefoxOptions.get(Keys.ARGS.key())).contains(arg)) {
                        newInstance.addArguments((String)arg);
                    }
                });
                Object binary = options.get("binary");
                if (binary instanceof String) {
                    newInstance.setBinary((String)binary);
                } else if (binary instanceof Path) {
                    newInstance.setBinary((Path)binary);
                }
                prefs.forEach(newInstance::addPreference);
                if (rawProfile != null) {
                    try {
                        newInstance.setProfile(FirefoxProfile.fromJson(rawProfile));
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                }
                if (logLevel != null) {
                    newInstance.setLogLevel(logLevel);
                }
            }
        }
        return newInstance;
    }

    private static enum Keys {
        ANDROID_PACKAGE("androidPackage"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                return null;
            }
        }
        ,
        ARGS("args"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (!(o instanceof List)) {
                    return;
                }
                ArrayList rawArgs = toAmend.getOrDefault(this.key(), new ArrayList());
                List existingArgs = rawArgs;
                List sourceArgs = (List)o;
                ArrayList newArgs = new ArrayList(existingArgs);
                newArgs.addAll(sourceArgs);
                toAmend.put(this.key(), Collections.unmodifiableList(new ArrayList(newArgs)));
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                ArrayList rawFirst = first.getOrDefault(this.key(), new ArrayList());
                Require.stateCondition((boolean)(rawFirst instanceof List), (String)"Args are of unexpected type: %s", (Object[])new Object[]{rawFirst});
                List firstList = rawFirst;
                ArrayList rawSecond = second.getOrDefault(this.key(), new ArrayList());
                Require.stateCondition((boolean)(rawSecond instanceof List), (String)"Args are of unexpected type: %s", (Object[])new Object[]{rawSecond});
                List secondList = rawSecond;
                ArrayList args = new ArrayList(firstList);
                args.addAll(secondList);
                return args.isEmpty() ? null : args;
            }
        }
        ,
        BINARY("binary"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o instanceof String) {
                    toAmend.put(this.key(), o);
                }
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                Object value = second.get(this.key());
                if (value == null) {
                    value = first.get(this.key());
                }
                if (value == null) {
                    return null;
                }
                Require.stateCondition((boolean)(value instanceof String), (String)"Unexpected type for binary: %s", (Object[])new Object[]{value});
                return value;
            }
        }
        ,
        ENV("env"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o == null) {
                    return;
                }
                Require.stateCondition((boolean)(o instanceof Map), (String)"Unexpected type for env: %s", (Object[])new Object[]{o});
                Map<String, Object> collected = ((Map)o).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
                toAmend.put(this.key(), Collections.unmodifiableMap(collected));
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                TreeMap rawFirst = first.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawFirst instanceof Map), (String)"Env vars are of unexpected type: %s", (Object[])new Object[]{rawFirst});
                Map firstPrefs = rawFirst;
                TreeMap rawSecond = second.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawSecond instanceof Map), (String)"Env vars are of unexpected type: %s", (Object[])new Object[]{rawSecond});
                Map secondPrefs = rawSecond;
                TreeMap value = new TreeMap(firstPrefs);
                value.putAll(secondPrefs);
                return value.isEmpty() ? null : value;
            }
        }
        ,
        LOG("log"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = toAmend.get(this.key());
                if (o == null) {
                    return;
                }
                Require.stateCondition((boolean)(o instanceof Map), (String)"Unexpected type for log: %s", (Object[])new Object[]{o});
                toAmend.put(this.key(), o);
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                Object value = second.get(this.key());
                if (value == null) {
                    value = first.get(this.key());
                }
                if (value == null) {
                    return null;
                }
                Require.stateCondition((boolean)(value instanceof Map), (String)"Log level is of unexpected type: %s", (Object[])new Object[]{value});
                return value;
            }
        }
        ,
        PREFS("prefs"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o == null) {
                    return;
                }
                Require.stateCondition((boolean)(o instanceof Map), (String)"Unexpected type for preferences: %s", (Object[])new Object[]{o});
                Map<String, Object> collected = ((Map)o).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
                toAmend.put(this.key(), Collections.unmodifiableMap(collected));
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                TreeMap rawFirst = first.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawFirst instanceof Map), (String)("Prefs are of unexpected type: " + String.valueOf(rawFirst)), (Object[])new Object[0]);
                Map firstPrefs = rawFirst;
                TreeMap rawSecond = second.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawSecond instanceof Map), (String)("Prefs are of unexpected type: " + String.valueOf(rawSecond)), (Object[])new Object[0]);
                Map secondPrefs = rawSecond;
                TreeMap value = new TreeMap(firstPrefs);
                value.putAll(secondPrefs);
                return value.isEmpty() ? null : value;
            }
        }
        ,
        PROFILE("profile"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o == null) {
                    return;
                }
                if (o instanceof FirefoxProfile) {
                    toAmend.put(this.key(), o);
                    return;
                }
                Require.stateCondition((boolean)(o instanceof String), (String)"Unexpected type for profile: %s", (Object[])new Object[]{o});
                toAmend.put(this.key(), o);
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                Object value = second.get(this.key());
                if (value == null) {
                    value = first.get(this.key());
                }
                if (value == null) {
                    return null;
                }
                Require.stateCondition((boolean)(value instanceof String), (String)"Profile is of unexpected type: %s", (Object[])new Object[]{value});
                return value;
            }
        };

        private final String key;

        private Keys(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public abstract void amend(Map<String, Object> var1, Map<String, Object> var2);

        public abstract Object mirror(Map<String, Object> var1, Map<String, Object> var2);
    }
}

