/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebElement
implements WebElement,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
FindsByXPath {
    protected String id;
    protected RemoteWebDriver parent;

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void click() {
        this.execute(DriverCommand.CLICK_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public void submit() {
        this.execute(DriverCommand.SUBMIT_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public String getValue() {
        return (String)this.execute(DriverCommand.GET_ELEMENT_VALUE, ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute(DriverCommand.SEND_KEYS_TO_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"value", (Object)keysToSend));
    }

    public void clear() {
        this.execute(DriverCommand.CLEAR_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public String getTagName() {
        return (String)this.execute(DriverCommand.GET_ELEMENT_TAG_NAME, ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public String getAttribute(String name) {
        Object value = this.execute(DriverCommand.GET_ELEMENT_ATTRIBUTE, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"name", (Object)name)).getValue();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public boolean toggle() {
        return (Boolean)this.execute(DriverCommand.TOGGLE_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public boolean isSelected() {
        return (Boolean)this.execute(DriverCommand.IS_ELEMENT_SELECTED, ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public void setSelected() {
        this.execute(DriverCommand.SET_ELEMENT_SELECTED, ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public boolean isEnabled() {
        return (Boolean)this.execute(DriverCommand.IS_ELEMENT_ENABLED, ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public String getText() {
        Response response = this.execute(DriverCommand.GET_ELEMENT_TEXT, ImmutableMap.of((Object)"id", (Object)this.id));
        return (String)response.getValue();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public WebElement findElementById(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"id", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsById(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"id", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByLinkText(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"link text", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"link text", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByName(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"name", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByName(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"name", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByClassName(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"class name", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByClassName(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"class name", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByXPath(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"xpath", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByXPath(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"xpath", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByPartialLinkText(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"partial link text", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"partial link text", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByTagName(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"tag name", (Object)"value", (Object)using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByTagName(String using) {
        Response response = this.execute(DriverCommand.FIND_CHILD_ELEMENTS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)"tag name", (Object)"value", (Object)using));
        return this.getElementsFrom(response);
    }

    protected Response execute(DriverCommand command, Object ... parameters) {
        return this.parent.execute(command, parameters);
    }

    protected WebElement getElementFrom(Response response) {
        return this.parent.getElementFrom(response);
    }

    protected List<WebElement> getElementsFrom(Response response) {
        return this.parent.getElementsFrom(response);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        Response response = this.execute(DriverCommand.ELEMENT_EQUALS, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"other", (Object)((RemoteWebElement)other).id));
        Object value = response.getValue();
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

