/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Map;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

public class RenderedRemoteWebElement
extends RemoteWebElement
implements RenderedWebElement {
    public boolean isDisplayed() {
        Response response = this.parent.execute(DriverCommand.IS_ELEMENT_DISPLAYED, ImmutableMap.of((Object)"id", (Object)this.id));
        return (Boolean)response.getValue();
    }

    public Point getLocation() {
        Response response = this.parent.execute(DriverCommand.GET_ELEMENT_LOCATION, ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Long)rawPoint.get("x")).intValue();
        int y = ((Long)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    public Dimension getSize() {
        Response response = this.parent.execute(DriverCommand.GET_ELEMENT_SIZE, ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Long)rawSize.get("width")).intValue();
        int height = ((Long)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }

    public void hover() {
        this.parent.execute(DriverCommand.HOVER_OVER_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        this.parent.execute(DriverCommand.DRAG_ELEMENT, ImmutableMap.of((Object)"id", (Object)this.id), moveRightBy, moveDownBy);
    }

    public void dragAndDropOn(RenderedWebElement element) {
        Point currentLocation = this.getLocation();
        Point destination = element.getLocation();
        this.dragAndDropBy(destination.x - currentLocation.x, destination.y - currentLocation.y);
    }

    public String getValueOfCssProperty(String propertyName) {
        Response response = this.parent.execute(DriverCommand.GET_ELEMENT_VALUE_OF_CSS_PROPERTY, ImmutableMap.of((Object)"id", (Object)this.id, (Object)"propertyName", (Object)propertyName));
        return (String)response.getValue();
    }
}

