/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.easymock.classextension.EasyMock;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.browserlaunchers.DummyLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSessionFactoryUnitTest
extends TestCase {
    private static final String SESSION_ID_1 = "testLookupByBrowserAndUrl1";
    private static final String BROWSER_1 = "*firefox";
    private static final String BASEURL1 = "http://www.google.com";
    private static final String SESSION_ID_2 = "testLookupByBrowserAndUrl2";
    private static final String BROWSER2 = "*firefox";
    private static final String BASEURL2 = "http://maps.google.com";

    public void testBrowserSessionFactorySetsLastSessionIdOfSeleniumDriverResourceHandler() throws Exception {
        BrowserLauncherFactory blf = (BrowserLauncherFactory)EasyMock.createMock(BrowserLauncherFactory.class);
        DummyLauncher launcherMock = (DummyLauncher)EasyMock.createMock(DummyLauncher.class);
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setTimeoutInSeconds(1);
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions();
        BrowserSessionFactory factory = new BrowserSessionFactory(blf){

            protected FrameGroupCommandQueueSet makeQueueSet(String sessionId, int port, RemoteControlConfiguration configuration) {
                return (FrameGroupCommandQueueSet)EasyMock.createMock(FrameGroupCommandQueueSet.class);
            }

            protected FrameGroupCommandQueueSet getQueueSet(String sessionId) {
                return (FrameGroupCommandQueueSet)EasyMock.createMock(FrameGroupCommandQueueSet.class);
            }
        };
        org.easymock.EasyMock.expect((Object)blf.getBrowserLauncher((String)org.easymock.EasyMock.isA(String.class), (String)org.easymock.EasyMock.isA(String.class), (RemoteControlConfiguration)org.easymock.EasyMock.isA(RemoteControlConfiguration.class), (BrowserConfigurationOptions)org.easymock.EasyMock.isA(BrowserConfigurationOptions.class))).andReturn((Object)launcherMock);
        launcherMock.launchRemoteSession("");
        org.easymock.EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{launcherMock});
        EasyMock.replay((Object[])new Object[]{blf});
        factory.createNewRemoteSession("", "", "", bco, true, configuration);
        String expected = ((BrowserSessionFactory.BrowserSessionInfo)factory.activeSessions.toArray()[0]).sessionId;
        BrowserSessionFactoryUnitTest.assertEquals((String)expected, (String)SeleniumDriverResourceHandler.getLastSessionId());
    }

    public void testInvalidLauncherPreventsNewRemoteSessionCreationWithException() {
        BrowserSessionFactory factory = new BrowserSessionFactory(new BrowserLauncherFactory());
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setTimeoutInSeconds(1);
        try {
            factory.createNewRemoteSession("*chrome invalid", "http://amazon.com", "", null, false, configuration);
            BrowserSessionFactoryUnitTest.fail((String)"Did not catch a RemoteCommandException when timing out on browser launch.");
        }
        catch (RuntimeException rte) {
        }
        catch (RemoteCommandException rce) {
            BrowserSessionFactoryUnitTest.fail((String)"RuntimeException was expected...");
        }
    }

    public void testIsValidWithInvalidSessionInfo() {
        BrowserSessionFactory.BrowserSessionInfo info = new BrowserSessionFactory.BrowserSessionInfo("id1", "*firefox", null, null, null);
        BrowserSessionFactoryUnitTest.assertNotNull((Object)info);
    }

    public void testLookupByBrowserAndUrl() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoByBrowserAndUrl("*firefox", BASEURL1, infos);
        BrowserSessionFactoryUnitTest.assertEquals((String)SESSION_ID_1, (String)result.sessionId);
    }

    public void testLookupByBrowserAndUrlWithNoMatch() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoByBrowserAndUrl("*firefox", "fooey", infos);
        BrowserSessionFactoryUnitTest.assertNull((Object)result);
    }

    public void testLookupBySessionId() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoBySessionId(SESSION_ID_2, infos);
        BrowserSessionFactoryUnitTest.assertEquals((String)BASEURL2, (String)result.baseUrl);
    }

    public void testLookupBySessionIdWithNoMatch() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoBySessionId("fooey", infos);
        BrowserSessionFactoryUnitTest.assertNull((Object)result);
    }

    public void testRegisterValidExternalSession() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        BrowserSessionFactory.BrowserSessionInfo info1 = this.getTestSession1();
        factory.registerExternalSession(info1);
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(info1.sessionId));
    }

    public void testRegisterInValidExternalSession() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        BrowserSessionFactory.BrowserSessionInfo info = new BrowserSessionFactory.BrowserSessionInfo(SESSION_ID_1, "*firefox", null, null, null);
        factory.registerExternalSession(info);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(info.sessionId));
    }

    public void testGrabAvailableSession() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.addToAvailableSessions(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasAvailableSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactory.BrowserSessionInfo result = factory.grabAvailableSession("*firefox", BASEURL1);
        BrowserSessionFactoryUnitTest.assertEquals((String)SESSION_ID_1, (String)result.sessionId);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(SESSION_ID_1));
    }

    public void testEndSessionWithNoCaching() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.registerExternalSession(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(SESSION_ID_1));
        factory.endBrowserSession(SESSION_ID_1, new RemoteControlConfiguration());
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    public void testEndSessionWithCaching() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.registerExternalSession(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(SESSION_ID_1));
        long closingTime = System.currentTimeMillis();
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setReuseBrowserSessions(true);
        factory.endBrowserSession(SESSION_ID_1, configuration);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasAvailableSession(SESSION_ID_1));
        BrowserSessionFactory.BrowserSessionInfo info = factory.lookupInfoBySessionId(SESSION_ID_1, factory.availableSessions);
        BrowserSessionFactoryUnitTest.assertTrue((info.lastClosedAt >= closingTime ? 1 : 0) != 0);
    }

    public void testEndAllBrowserSessions() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.registerExternalSession(this.getTestSession1());
        factory.addToAvailableSessions(this.getTestSession2());
        factory.endAllBrowserSessions(new RemoteControlConfiguration());
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_2));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    public void testRemoveIdleAvailableSessions() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.addToAvailableSessions(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasAvailableSession(SESSION_ID_1));
        factory.removeIdleAvailableSessions();
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    public void disable_testRemoveIdleAvailableSessionsViaCleanup() {
        BrowserSessionFactory factory = new BrowserSessionFactory(null, 5L, 0L, true);
        BrowserSessionFactory.BrowserSessionInfo info1 = this.getTestSession1();
        info1.lastClosedAt = 0L;
        factory.addToAvailableSessions(info1);
        FrameGroupCommandQueueSet.sleepForAtLeast((long)5L);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    private Set<BrowserSessionFactory.BrowserSessionInfo> getTestSessionSet() {
        HashSet<BrowserSessionFactory.BrowserSessionInfo> infos = new HashSet<BrowserSessionFactory.BrowserSessionInfo>();
        BrowserSessionFactory.BrowserSessionInfo info1 = this.getTestSession1();
        infos.add(info1);
        BrowserSessionFactory.BrowserSessionInfo info2 = this.getTestSession2();
        infos.add(info2);
        return infos;
    }

    private BrowserSessionFactory.BrowserSessionInfo getTestSession1() {
        DummyLauncher mockLauncher1 = new DummyLauncher();
        return new BrowserSessionFactory.BrowserSessionInfo(SESSION_ID_1, "*firefox", BASEURL1, (BrowserLauncher)mockLauncher1, null);
    }

    private BrowserSessionFactory.BrowserSessionInfo getTestSession2() {
        DummyLauncher mockLauncher2 = new DummyLauncher();
        return new BrowserSessionFactory.BrowserSessionInfo(SESSION_ID_2, "*firefox", BASEURL2, (BrowserLauncher)mockLauncher2, null);
    }

    private BrowserSessionFactory getTestSessionFactory() {
        return new BrowserSessionFactory(null, 0L, 0L, false);
    }
}

