/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandHolder;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;
import org.openqa.selenium.testworker.TrackableRunnable;
import org.openqa.selenium.testworker.TrackableThread;

public class CommandHolderUnitTest
extends TestCase {
    private static Log log = LogFactory.getLog(CommandHolderUnitTest.class);
    private static final String sessionId = "1";
    private static final String testCommand = "testCommand";
    private static final String testArg1 = "arg1";
    private static final String testArg2 = "arg2";
    private static final RemoteCommand testRemoteCommand = new DefaultRemoteCommand("testCommand", "arg1", "arg2");
    private static final int retryTimeout = 2;
    private CommandHolder holder;

    public void setUp() throws Exception {
        this.configureLogging();
        this.holder = new CommandHolder(sessionId, 2);
        log.info((Object)("Start test: " + this.getName()));
    }

    private void configureLogging() throws Exception {
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)true);
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof StdOutHandler)) continue;
            handler.setFormatter((Formatter)new TerseFormatter(true));
            break;
        }
    }

    public void tearDown() throws Exception {
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)false);
    }

    public void testGetCommandGeneratesRetryWhenNoCommand() {
        long now = System.currentTimeMillis();
        RemoteCommand nextCmd = this.holder.getCommand();
        long after = System.currentTimeMillis();
        CommandHolderUnitTest.assertNotNull((Object)nextCmd);
        CommandHolderUnitTest.assertEquals((String)"retryLast", (String)nextCmd.getCommand());
        CommandHolderUnitTest.assertTrue((after - now >= 1998L ? 1 : 0) != 0);
        CommandHolderUnitTest.assertNull((Object)this.holder.peek());
    }

    public void testGetCommandGeneratesNullWhenPoisoned() throws Throwable {
        TrackableRunnable internalGetter = new TrackableRunnable(){

            public Object go() throws Throwable {
                RemoteCommand result = CommandHolderUnitTest.this.holder.getCommand();
                log.debug((Object)(Thread.currentThread().getName() + " got result: " + result));
                return result;
            }
        };
        String name = "launching getter";
        TrackableThread t = new TrackableThread(internalGetter, name);
        t.start();
        this.holder.poisonPollers();
        CommandHolderUnitTest.assertNull((Object)t.getResult());
    }

    public void testSimpleSingleThreaded() throws Throwable {
        this.injectCommand(testRemoteCommand, true);
        this.expectCommand(testRemoteCommand);
        CommandHolderUnitTest.assertTrue((boolean)this.holder.isEmpty());
    }

    private void injectCommand(RemoteCommand cmd, boolean expected) throws Throwable {
        boolean actual = this.holder.putCommand(cmd);
        CommandHolderUnitTest.assertEquals((String)(cmd + "command got sent"), (boolean)expected, (boolean)actual);
    }

    private void expectCommand(RemoteCommand expected) throws Throwable {
        RemoteCommand actual = this.holder.getCommand();
        CommandHolderUnitTest.assertEquals((String)(expected + " command retrieved"), (Object)expected, (Object)actual);
    }
}

