/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.http.HttpResponse;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.SpecialCommand;

public class SeleniumDriverResourceHandlerUnitTest {
    private static String firstSessionId = "session 1";
    private static int defaultSpeed = CommandQueue.getSpeed();
    private static int newSpeed = defaultSpeed + 42;
    private static String defaultSpeedString = "OK," + defaultSpeed;
    private static String newSpeedString = "OK," + newSpeed;

    @Test
    public void testGetDefaultSpeedNullSession() {
        Assert.assertEquals((long)defaultSpeed, (long)CommandQueue.getSpeed());
        String speed = SeleniumDriverResourceHandler.getSpeedForSession(null);
        Assert.assertEquals((Object)defaultSpeedString, (Object)speed);
    }

    @Test
    public void testGetPresetSpeedNullSession() {
        Assert.assertEquals((long)defaultSpeed, (long)CommandQueue.getSpeed());
        CommandQueue.setSpeed((int)newSpeed);
        String speed = SeleniumDriverResourceHandler.getSpeedForSession(null);
        Assert.assertEquals((Object)newSpeedString, (Object)speed);
        CommandQueue.setSpeed((int)defaultSpeed);
    }

    @Test
    public void testGetPresetSpeedValidSession() {
        Assert.assertEquals((long)defaultSpeed, (long)CommandQueue.getSpeed());
        FrameGroupCommandQueueSet session1 = FrameGroupCommandQueueSet.makeQueueSet((String)firstSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        Assert.assertNotNull((Object)session1);
        SeleniumDriverResourceHandler.setSpeedForSession((String)firstSessionId, (int)newSpeed);
        String speed = SeleniumDriverResourceHandler.getSpeedForSession((String)firstSessionId);
        Assert.assertEquals((Object)newSpeedString, (Object)speed);
        FrameGroupCommandQueueSet.clearQueueSet((String)firstSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrowsExceptionOnFailedBrowserLaunch() throws Exception {
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setTimeoutInSeconds(3);
        SeleniumServer server = new SeleniumServer(false, configuration);
        server.start();
        SeleniumDriverResourceHandler sdrh = new SeleniumDriverResourceHandler(server);
        try {
            sdrh.getNewBrowserSession("*mock", null, "", new BrowserConfigurationOptions());
            Assert.fail((String)"Launch should have failed");
        }
        catch (RemoteCommandException rce) {
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void attachFile_preservesFileName() throws Exception {
        String fileName = "toDownload";
        String locator = "field";
        SeleniumServer server = (SeleniumServer)EasyMock.createMock(SeleniumServer.class);
        final FrameGroupCommandQueueSet queueSet = (FrameGroupCommandQueueSet)EasyMock.createMock(FrameGroupCommandQueueSet.class);
        SeleniumDriverResourceHandler handler = new SeleniumDriverResourceHandler(server){

            protected FrameGroupCommandQueueSet getQueueSet(String sessionId) {
                return queueSet;
            }

            protected void downloadWithAnt(URL url, File outputFile) {
            }
        };
        queueSet.addTemporaryFile((File)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        String tmpDir = System.getProperty("java.io.tmpdir");
        int tmpDirLength = tmpDir.length();
        if (tmpDir.lastIndexOf(File.separator) == tmpDirLength - 1) {
            tmpDir = tmpDir.substring(0, tmpDirLength - 1);
        }
        EasyMock.expect((Object)queueSet.doCommand("type", locator, tmpDir + File.separator + fileName)).andReturn((Object)"OK");
        EasyMock.replay((Object[])new Object[]{queueSet});
        Vector<String> values = new Vector<String>();
        values.add(locator);
        values.add("file:///" + fileName);
        String result = handler.doCommand("attachFile", values, "sessionId", null);
        Assert.assertEquals((Object)"OK", (Object)result);
        EasyMock.verify((Object[])new Object[]{queueSet});
    }

    @Test
    public void shutDownSeleniumServer_willBeProcessedInDoCommand() throws Exception {
        SeleniumServer server = (SeleniumServer)EasyMock.createNiceMock(SeleniumServer.class);
        HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
        OutputStream stream = (OutputStream)EasyMock.createNiceMock(OutputStream.class);
        SeleniumDriverResourceHandler handler = new SeleniumDriverResourceHandler(server);
        EasyMock.expect((Object)response.getOutputStream()).andReturn((Object)stream);
        response.commit();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{response});
        String result = handler.doCommand(SpecialCommand.shutDownSeleniumServer.toString(), new Vector(), "sessionId", response);
        EasyMock.verify((Object[])new Object[]{response});
        Assert.assertEquals((Object)"OK", (Object)result);
    }
}

