/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;

public class SeleniumServerUnitTest {
    private int positiveJettyThreads = SeleniumServer.DEFAULT_JETTY_THREADS;
    private SeleniumServer server;

    @Test
    public void constructor_setsThisAsSeleniumServerInRemoteControlConfiguration() throws Exception {
        RemoteControlConfiguration remoteConfiguration = new RemoteControlConfiguration();
        this.server = new SeleniumServer(remoteConfiguration);
        Assert.assertEquals((Object)this.server, (Object)remoteConfiguration.getSeleniumServer());
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testJettyThreadsPositive() throws Exception {
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setJettyThreads(this.positiveJettyThreads);
        this.server = new SeleniumServer(configuration);
        this.server.start();
        Assert.assertEquals((String)"Jetty threads given is not correct.", (long)this.positiveJettyThreads, (long)this.server.getJettyThreads());
    }
}

