/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;
import org.openqa.selenium.testworker.TrackableRunnable;
import org.openqa.selenium.testworker.TrackableThread;

public class SingleEntryAsyncQueueUnitTest
extends TestCase {
    private static final Log logger = LogFactory.getLog(SingleEntryAsyncQueueUnitTest.class);
    private static final String testCommand = "testCommand";
    private static final String completeCommand = "testComplete";
    private static final String poisonString = "POISON";
    private static final int timeout = 3;
    private static final int MILLISECONDS = 1000;
    private SingleEntryAsyncQueue<String> queue;

    public void setUp() throws Exception {
        this.configureLogging();
        this.queue = new SingleEntryAsyncQueue(3);
        logger.info((Object)("Start test: " + this.getName()));
    }

    public void tearDown() throws Exception {
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)false);
    }

    public void testPeekReturnsNullWhenEmpty() {
        SingleEntryAsyncQueueUnitTest.assertNull((Object)this.queue.peek());
    }

    public void testPollReturnsNullAfterTimeout() {
        String nextRes = (String)this.queue.pollToGetContentUntilTimeout();
        SingleEntryAsyncQueueUnitTest.assertNull((Object)nextRes);
    }

    public void testPollDoesNotReturnBeforeTheTimeoutWhenTimingOut() {
        long now = System.currentTimeMillis();
        this.queue.pollToGetContentUntilTimeout();
        long after = System.currentTimeMillis();
        long duration = after - now;
        SingleEntryAsyncQueueUnitTest.assertTrue((String)("Returned too fast : " + duration + " ms"), (duration >= 3000L ? 1 : 0) != 0);
    }

    public void testPollReturnAtLeastWithinTwiceTheTimeoutValueWhenTimingOut() {
        long now = System.currentTimeMillis();
        this.queue.pollToGetContentUntilTimeout();
        long after = System.currentTimeMillis();
        long duration = after - now;
        SingleEntryAsyncQueueUnitTest.assertTrue((String)("Duration more than twice the timeout: " + duration + " ms"), (duration / 1000L <= 6L ? 1 : 0) != 0);
    }

    public void testQueueIsEmptyWhenCreated() {
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testQueueNotEmptyWhenContentIsPut() {
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.putContent((Object)testCommand));
        SingleEntryAsyncQueueUnitTest.assertFalse((boolean)this.queue.isEmpty());
    }

    public void testPutContentReturnsFalseWhenPuttingTwice() {
        this.queue.putContent((Object)testCommand);
        SingleEntryAsyncQueueUnitTest.assertFalse((boolean)this.queue.putContent((Object)completeCommand));
    }

    public void testPutContentReturnsPreviousCommandWhenPuttingTwice() {
        this.queue.putContent((Object)testCommand);
        this.queue.putContent((Object)completeCommand);
        SingleEntryAsyncQueueUnitTest.assertEquals((String)testCommand, (String)((String)this.queue.peek()));
    }

    public void testPollingContentReturnsCommandPreviouslyPut() throws Throwable {
        this.queue.putContent((Object)testCommand);
        SingleEntryAsyncQueueUnitTest.assertEquals((String)testCommand, (String)((String)this.queue.pollToGetContentUntilTimeout()));
    }

    public void testCommandGotPickedUpAndQueueIsEmptyWhenPollingContentReturns() throws Throwable {
        this.queue.putContent((Object)testCommand);
        this.queue.pollToGetContentUntilTimeout();
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testCanPollTwice() throws Throwable {
        this.queue.putContent((Object)testCommand);
        SingleEntryAsyncQueueUnitTest.assertEquals((String)testCommand, (String)((String)this.queue.pollToGetContentUntilTimeout()));
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.isEmpty());
        this.queue.putContent((Object)completeCommand);
        SingleEntryAsyncQueueUnitTest.assertEquals((String)completeCommand, (String)((String)this.queue.pollToGetContentUntilTimeout()));
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testCanPollContentThatWhatPutByADifferentThread() throws Throwable {
        new Thread((Runnable)new AsyncCommandSender(testCommand), "launching sender").start();
        SingleEntryAsyncQueueUnitTest.assertEquals((String)testCommand, (String)((String)this.queue.pollToGetContentUntilTimeout()));
        SingleEntryAsyncQueueUnitTest.assertNull((Object)this.queue.peek());
    }

    public void testCanGetResultPostedByTheMainThreadFromAnotherThread() throws Throwable {
        TrackableThread getter = new TrackableThread(new AsyncCommandGetter(), "launching getter");
        getter.start();
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.putContent((Object)testCommand));
        SingleEntryAsyncQueueUnitTest.assertEquals((Object)testCommand, (Object)getter.getResult());
        SingleEntryAsyncQueueUnitTest.assertNull((Object)this.queue.peek());
    }

    public void testCanPutAndGetResultsFromDifferentThreads() throws Throwable {
        new TrackableThread(new AsyncCommandSender(testCommand), "launching sender").start();
        TrackableThread firstGetter = new TrackableThread(new AsyncCommandGetter(), "launching firstGetter");
        firstGetter.start();
        SingleEntryAsyncQueueUnitTest.assertEquals((Object)testCommand, (Object)firstGetter.getResult());
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.putContent((Object)completeCommand));
        TrackableThread secondGetter = new TrackableThread(new AsyncCommandGetter(), "launching firstGetter");
        secondGetter.start();
        SingleEntryAsyncQueueUnitTest.assertEquals((Object)completeCommand, (Object)secondGetter.getResult());
    }

    public void testPollReturnsPoisonOncePoisonedAndPoisonPollersIsCalled() throws Throwable {
        this.queue.setPoison((Object)poisonString);
        TrackableThread getter = new TrackableThread(new AsyncCommandGetter(), "launching getter");
        getter.start();
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.poisonPollers());
        SingleEntryAsyncQueueUnitTest.assertEquals((Object)poisonString, (Object)getter.getResult());
    }

    public void testPoisonPollersClearContentWhenThereIsNoPoison() throws Throwable {
        this.queue.putContent((Object)"some command");
        SingleEntryAsyncQueueUnitTest.assertFalse((boolean)this.queue.poisonPollers());
        SingleEntryAsyncQueueUnitTest.assertTrue((boolean)this.queue.isEmpty());
    }

    private void configureLogging() throws Exception {
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)true);
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof StdOutHandler)) continue;
            handler.setFormatter((Formatter)new TerseFormatter(true));
            break;
        }
    }

    private class AsyncCommandGetter
    extends TrackableRunnable {
        public Object go() throws Throwable {
            String result = (String)SingleEntryAsyncQueueUnitTest.this.queue.pollToGetContentUntilTimeout();
            logger.debug((Object)(Thread.currentThread().getName() + " got result: " + result));
            return result;
        }
    }

    private class AsyncCommandSender
    extends TrackableRunnable {
        private String content;

        public AsyncCommandSender(String content) {
            this.content = content;
        }

        public Object go() throws Throwable {
            boolean result = SingleEntryAsyncQueueUnitTest.this.queue.putContent((Object)this.content);
            logger.debug((Object)(Thread.currentThread().getName() + " got result: " + result));
            return new Boolean(result);
        }
    }
}

