/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;

public class FirefoxChromeLauncherUnitTest {
    final BrowserConfigurationOptions browserOptions = new BrowserConfigurationOptions();
    final RemoteControlConfiguration configuration = new RemoteControlConfiguration();

    @Test
    public void testInvalidBrowserStringCausesChromeLauncherToThrowException() {
        try {
            new FirefoxChromeLauncher(new BrowserConfigurationOptions(), null, null, "invalid");
            Assert.fail((String)"No exception thrown");
        }
        catch (InvalidBrowserExecutableException ibee) {
            Assert.assertEquals((Object)"The specified path to the browser executable is invalid.", (Object)ibee.getMessage());
        }
    }

    @Test
    public void nullBrowserInstallationDoesCauseChromeLauncherToThrowException() {
        BrowserInstallation browserInstallation = null;
        try {
            new FirefoxChromeLauncher(new BrowserConfigurationOptions(), null, null, browserInstallation);
            Assert.fail((String)"No exception thrown");
        }
        catch (InvalidBrowserExecutableException ibee) {
            Assert.assertEquals((Object)"The specified path to the browser executable is invalid.", (Object)ibee.getMessage());
        }
    }

    @Test
    public void testShouldAbleToCreateChromeUrlWithNormalUrl() throws Exception {
        String httpUrl = "http://www.my.com/folder/endname.html?a=aaa&b=bbb";
        String chromeUrl = new FirefoxChromeLauncher.ChromeUrlConvert().convert(httpUrl);
        Assert.assertEquals((Object)"chrome://src/content/endname.html?a=aaa&b=bbb", (Object)chromeUrl);
    }

    @Test
    public void testProfileRemovedWhenProcessNull() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.close();
        Assert.assertFalse((boolean)launcher.wasKillFirefoxProcessCalled());
        Assert.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    @Test
    public void testProfileRemovedWhenProcessKillFails() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.haveProcessKillThrowException(false);
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.setProcess(new TestProcess());
        launcher.close();
        Assert.assertTrue((boolean)launcher.wasKillFirefoxProcessCalled());
        Assert.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    @Test
    public void testProfileRemovedWhenProcessNotNull() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.setProcess(new TestProcess());
        launcher.close();
        Assert.assertTrue((boolean)launcher.wasKillFirefoxProcessCalled());
        Assert.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    @Test
    public void testNothingRemovedIfAlreadyNull() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.close();
        Assert.assertFalse((boolean)launcher.wasKillFirefoxProcessCalled());
        Assert.assertFalse((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    @Test
    public void testSecondCloseIsNoOp() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.close();
        Assert.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
        launcher.reset();
        launcher.close();
        Assert.assertFalse((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    @Test
    public void copyCert8db_copyiesOnlyIfFileExists() throws Exception {
        BrowserConfigurationOptions browserOptions = new BrowserConfigurationOptions();
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        File firefoxProfileTemplate = new File("x");
        final File certFile = (File)EasyMock.createMock(File.class);
        BrowserInstallation browserInstallation = (BrowserInstallation)EasyMock.createMock(BrowserInstallation.class);
        FirefoxChromeLauncher launcher = new FirefoxChromeLauncher(browserOptions, configuration, "session", browserInstallation){

            protected void copySingleFileWithOverwrite(File sourceFile, File destFile) {
            }

            protected File getFileFromParent(File parent, String child) {
                return certFile;
            }
        };
        EasyMock.expect((Object)certFile.exists()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{certFile});
        launcher.copyCert8db(firefoxProfileTemplate);
        EasyMock.verify((Object[])new Object[]{certFile});
    }

    @Test
    public void initProfileTemplate_usesBrowserOptionIfNoProfilesLocationSpecified() throws Exception {
        BrowserInstallation browserInstallation = (BrowserInstallation)EasyMock.createMock(BrowserInstallation.class);
        FirefoxChromeLauncher launcher = new FirefoxChromeLauncher(this.browserOptions, this.configuration, "session", browserInstallation){

            protected void copyDirectory(File sourceDir, File destDir) {
            }
        };
        this.browserOptions.set("firefoxProfileTemplate", (Object)"profileTemplate");
        File result = launcher.initProfileTemplate();
        Assert.assertEquals((Object)"profileTemplate", (Object)result.getName());
    }

    @Test
    public void initProfileTemplate_usesProfilesLocationAlongWithRelativeProfileIfTheirAbsoluteTemplateExists() throws Exception {
        BrowserInstallation browserInstallation = (BrowserInstallation)EasyMock.createMock(BrowserInstallation.class);
        final File profileTemplate = (File)EasyMock.createMock(File.class);
        FirefoxChromeLauncher launcher = new FirefoxChromeLauncher(this.browserOptions, this.configuration, "session", browserInstallation){

            protected void copyDirectory(File sourceDir, File destDir) {
            }

            protected File getFileFromParent(File parent, String child) {
                return profileTemplate;
            }
        };
        EasyMock.expect((Object)profileTemplate.exists()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{profileTemplate});
        this.configuration.setProfilesLocation(profileTemplate);
        this.browserOptions.set("profile", (Object)"profile");
        File result = launcher.initProfileTemplate();
        EasyMock.verify((Object[])new Object[]{profileTemplate});
        Assert.assertEquals((Object)profileTemplate, (Object)result);
    }

    public static class TestProcess
    extends Process {
        public void destroy() {
        }

        public int exitValue() {
            return 0;
        }

        public InputStream getErrorStream() {
            return null;
        }

        public InputStream getInputStream() {
            return null;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public int waitFor() throws InterruptedException {
            return 0;
        }
    }

    public static class FirefoxChromeLauncherStubbedForShutdown
    extends FirefoxChromeLauncher {
        private boolean killFirefoxProcessCalled = false;
        private boolean removeCustomProfileDirCalled = false;
        private boolean throwProcessKillException = true;

        public FirefoxChromeLauncherStubbedForShutdown() {
            super(new BrowserConfigurationOptions(), new RemoteControlConfiguration(), "testsession", (String)null);
        }

        public void haveProcessKillThrowException(boolean doThrow) {
            this.throwProcessKillException = doThrow;
        }

        public void reset() {
            this.killFirefoxProcessCalled = false;
            this.removeCustomProfileDirCalled = false;
            this.throwProcessKillException = true;
        }

        public boolean wasKillFirefoxProcessCalled() {
            return this.killFirefoxProcessCalled;
        }

        public boolean wasRemoveCustomProfileCalled() {
            return this.removeCustomProfileDirCalled;
        }

        protected void killFirefoxProcess() throws FirefoxChromeLauncher.FileLockRemainedException {
            this.killFirefoxProcessCalled = true;
            if (!this.throwProcessKillException) {
                throw new FirefoxChromeLauncher.FileLockRemainedException((FirefoxChromeLauncher)this, "test exception");
            }
        }

        protected void removeCustomProfileDir() throws RuntimeException {
            this.removeCustomProfileDirCalled = true;
        }
    }
}

