/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.openqa.selenium.server.ModifiedIO;
import org.openqa.selenium.server.commands.CaptureNetworkTrafficCommand;

public class CaptureNetworkTrafficCommandTest
extends TestCase {
    public void testJson() throws ParseException, IOException {
        this.prepare();
        this.check("json", "json.txt");
    }

    public void testXml() throws ParseException, IOException {
        this.prepare();
        this.check("xml", "xml.xml");
    }

    public void testPlain() throws ParseException, IOException {
        this.prepare();
        this.check("plain", "plain.txt");
    }

    private void check(String type, String file) throws IOException {
        CaptureNetworkTrafficCommand c = new CaptureNetworkTrafficCommand(type);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/openqa/selenium/server/commands/" + file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ModifiedIO.copy((InputStream)is, (OutputStream)baos);
        String result = c.execute();
        CaptureNetworkTrafficCommandTest.assertTrue((boolean)result.startsWith("OK,"));
        CaptureNetworkTrafficCommandTest.assertEquals((String)baos.toString(), (String)result.substring(3));
    }

    private void prepare() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date start = sdf.parse("2009-04-15T09:22:41.000-0700");
        Date end = sdf.parse("2009-04-15T09:22:41.102-0700");
        final TreeMap<String, String> requestHeaders = new TreeMap<String, String>();
        requestHeaders.put("foo", "bar");
        requestHeaders.put("baz", "blah");
        HttpRequest req = new HttpRequest(){

            public Enumeration getFieldNames() {
                return Collections.enumeration(requestHeaders.keySet());
            }

            public String getField(String name) {
                return (String)requestHeaders.get(name);
            }
        };
        HttpResponse res = new HttpResponse(){

            public Enumeration getFieldNames() {
                return Collections.enumeration(requestHeaders.keySet());
            }

            public String getField(String name) {
                return (String)requestHeaders.get(name);
            }
        };
        CaptureNetworkTrafficCommand.clear();
        CaptureNetworkTrafficCommand.Entry entry = new CaptureNetworkTrafficCommand.Entry("GET", "http://example.com/index.html");
        entry.setStart(start);
        entry.finish(404, 1234L);
        entry.setEnd(end);
        entry.addRequestHeaders(req);
        entry.addResponseHeader(res);
        CaptureNetworkTrafficCommand.capture((CaptureNetworkTrafficCommand.Entry)entry);
        entry = new CaptureNetworkTrafficCommand.Entry("GET", "http://example.com/index2.html?foo=\"bar\"");
        entry.setStart(start);
        entry.finish(200, 1234L);
        entry.setEnd(end);
        entry.addRequestHeaders(req);
        entry.addResponseHeader(res);
        CaptureNetworkTrafficCommand.capture((CaptureNetworkTrafficCommand.Entry)entry);
        entry = new CaptureNetworkTrafficCommand.Entry("GET", "http://example.com/index3.html?foo='bar'");
        entry.setStart(start);
        entry.finish(302, 1234L);
        entry.setEnd(end);
        requestHeaders.put("'\"special\nchar\"'", "today's\ntest \"is\"\n<great>!");
        entry.addRequestHeaders(req);
        entry.addResponseHeader(res);
        CaptureNetworkTrafficCommand.capture((CaptureNetworkTrafficCommand.Entry)entry);
    }
}

