/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.BrowserConfigurationOptions;
import junit.framework.TestCase;

public class BrowserConfigurationOptionsTest
extends TestCase {
    public void testCanUseWithValidArg() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions();
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.canUse("foobar"));
    }

    public void testCanUseWithNullArg() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions();
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.canUse(null));
    }

    public void testCanUseWithEmptyArg() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions();
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.canUse(""));
    }

    public void testSetProfileWithNullDoesNotSet() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setProfile(null);
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.isSet("profile"));
    }

    public void testSetProfileWithNonNullDoesSet() {
        String profile = "foo";
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setProfile(profile);
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("profile"));
        BrowserConfigurationOptionsTest.assertEquals((String)profile, (String)bco.getProfile());
    }

    public void testSetSingleWindow() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setSingleWindow();
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSingleWindow());
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("singleWindow"));
    }

    public void testSetSingleWindowWhenMultiWindowWasAlreadySet() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setMultiWindow().setSingleWindow();
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSingleWindow());
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.isMultiWindow());
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("singleWindow"));
    }

    public void testSetMultiWindow() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setMultiWindow();
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isMultiWindow());
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("multiWindow"));
    }

    public void testSetMultiWindowWhenSingleWindowWasAlreadySet() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setSingleWindow().setMultiWindow();
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isMultiWindow());
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.isSingleWindow());
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("multiWindow"));
    }

    public void testSetBrowserExecutablePathWithNullPath() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setBrowserExecutablePath(null);
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.isSet("executablePath"));
    }

    public void testSetBrowserExcecutablePathWithValidPath() {
        String path = "c:\\chrome\\is\\cool.exe with_arg";
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setBrowserExecutablePath(path);
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("executablePath"));
        BrowserConfigurationOptionsTest.assertEquals((String)path, (String)bco.getBrowserExecutablePath());
    }

    public void testSetTimeoutInSeconds() {
        int timeout = 17;
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setTimeoutInSeconds(timeout);
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("timeoutInSeconds"));
        BrowserConfigurationOptionsTest.assertEquals((int)timeout, (int)bco.getTimeoutInSeconds());
    }

    public void testGetTimeoutWhenNoneSet() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions();
        BrowserConfigurationOptionsTest.assertEquals((int)1800, (int)bco.getTimeoutInSeconds());
    }

    public void testBrowserModeWithNullMode() {
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setBrowserMode(null);
        BrowserConfigurationOptionsTest.assertFalse((boolean)bco.isSet("mode"));
    }

    public void testBrowserModeWithNonNullMode() {
        String mode = "hta";
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setBrowserMode(mode);
        BrowserConfigurationOptionsTest.assertTrue((boolean)bco.isSet("mode"));
        BrowserConfigurationOptionsTest.assertEquals((String)mode, (String)bco.getBrowserMode());
    }

    public void testServerOptionsCanLoadClientOptions() {
        String profile = "foo";
        String execPath = "c:\\simon stewart\\likes\\cheese";
        BrowserConfigurationOptions bco = new BrowserConfigurationOptions().setSingleWindow().setProfile(profile).setBrowserExecutablePath(execPath);
        org.openqa.selenium.server.BrowserConfigurationOptions serverOptions = new org.openqa.selenium.server.BrowserConfigurationOptions(bco.toString());
        BrowserConfigurationOptionsTest.assertEquals((String)profile, (String)serverOptions.getProfile());
        BrowserConfigurationOptionsTest.assertEquals((String)execPath, (String)serverOptions.getExecutablePath());
        BrowserConfigurationOptionsTest.assertTrue((boolean)serverOptions.isSingleWindow());
    }
}

