/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.thoughtworks.selenium.SeleniumException;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;

public class ElementFinder {
    private final String findElement;
    private Map<String, String> additionalLocators = Maps.newHashMap();

    @VisibleForTesting
    protected ElementFinder() {
        this.findElement = null;
    }

    public ElementFinder(JavascriptLibrary library) {
        String rawScript = library.getSeleniumScript("findElement.js");
        this.findElement = "return (" + rawScript + ")(arguments[0]);";
        String linkTextLocator = "return (" + library.getSeleniumScript("linkLocator.js") + ").call(null, arguments[0], document)";
        this.add("link", linkTextLocator);
    }

    public WebElement findElement(WebDriver driver, String locator) {
        WebElement toReturn = null;
        String strategy = this.searchAdditionalStrategies(locator);
        if (strategy != null) {
            String actualLocator = locator.substring(locator.indexOf(61) + 1);
            try {
                toReturn = (WebElement)((JavascriptExecutor)driver).executeScript(strategy, new Object[]{actualLocator});
                if (toReturn == null) {
                    throw new SeleniumException("Element " + locator + " not found");
                }
                return toReturn;
            }
            catch (WebDriverException e) {
                throw new SeleniumException("Element " + locator + " not found");
            }
        }
        try {
            toReturn = this.findElementDirectlyIfNecessary(driver, locator);
            if (toReturn != null) {
                return toReturn;
            }
            return (WebElement)((JavascriptExecutor)driver).executeScript(this.findElement, new Object[]{locator});
        }
        catch (WebDriverException e) {
            throw new SeleniumException("Element " + locator + " not found", (Exception)((Object)e));
        }
    }

    public void add(String strategyName, String implementation) {
        this.additionalLocators.put(strategyName, implementation);
    }

    private String searchAdditionalStrategies(String locator) {
        int index = locator.indexOf(61);
        if (index == -1) {
            return null;
        }
        String key = locator.substring(0, index);
        return this.additionalLocators.get(key);
    }

    private WebElement findElementDirectlyIfNecessary(WebDriver driver, String locator) {
        if (locator.startsWith("xpath=")) {
            return driver.findElement(By.xpath((String)locator.substring("xpath=".length())));
        }
        if (locator.startsWith("//")) {
            return driver.findElement(By.xpath((String)locator));
        }
        if (locator.startsWith("css=")) {
            return driver.findElement(By.cssSelector((String)locator.substring("css=".length())));
        }
        return null;
    }
}

