/*
Copyright 2007-2009 WebDriver committers
Copyright 2007-2009 Google Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Copyright 2008 Google Inc.  All Rights Reserved.

package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;

import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.interactions.internal.Coordinates;

import java.util.Map;

public class RenderedRemoteWebElement extends RemoteWebElement implements RenderedWebElement,
    Locatable {

  public void dragAndDropBy(int moveRightBy, int moveDownBy) {
    parent.execute(DriverCommand.DRAG_ELEMENT,
        ImmutableMap.of("id", id, "x", moveRightBy, "y", moveDownBy));
  }

  public void dragAndDropOn(RenderedWebElement element) {
    Point currentLocation = getLocation();
    Point destination = element.getLocation();
    dragAndDropBy(destination.x - currentLocation.x, destination.y - currentLocation.y);
  }

  public String getValueOfCssProperty(String propertyName) {
    return getCssValue(propertyName);
  }

  public Point getLocationOnScreenOnceScrolledIntoView() {
    Response response = execute(DriverCommand.GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW,
        ImmutableMap.of("id", getId()));

    @SuppressWarnings("unchecked")
    Map<String, Number> mapped = (Map<String, Number>) response.getValue();

    return new Point(mapped.get("x").intValue(), mapped.get("y").intValue());
  }

  public Coordinates getCoordinates() {
    return new Coordinates() {

      public Point getLocationOnScreen() {
        return getLocationOnScreenOnceScrolledIntoView();
      }

      public Point getLocationInViewPort() {
        throw new UnsupportedOperationException("Not supported yet.");
      }

      public Point getLocationInDOM() {
        throw new UnsupportedOperationException("Not supported yet.");
      }

      public Object getAuxiliry() {
        return getId();
      }
    };
  }
}
