/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.Tracer;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTags;
import org.openqa.selenium.remote.tracing.HttpTracing;

public class SpanWrappedHttpHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(SpanWrappedHttpHandler.class.getName());
    private final Tracer tracer;
    private final Function<HttpRequest, String> namer;
    private final HttpHandler delegate;

    public SpanWrappedHttpHandler(Tracer tracer, Function<HttpRequest, String> namer, HttpHandler delegate) {
        this.tracer = Objects.requireNonNull(tracer, "Tracer to use must be set.");
        this.namer = Objects.requireNonNull(namer, "Naming function must be set.");
        this.delegate = Objects.requireNonNull(delegate, "Actual handler must be set.");
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        String name = Objects.requireNonNull(this.namer.apply(req), "Operation name must be set for " + req);
        Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, name).setSpanKind(Span.Kind.SERVER).startSpan();
        try {
            HttpResponse httpResponse;
            block11: {
                Scope scope = this.tracer.withSpan(span);
                try {
                    HttpTags.HTTP_REQUEST.accept(span, req);
                    HttpTracing.inject(this.tracer, span, req);
                    HttpResponse res = this.delegate.execute(req);
                    HttpTags.HTTP_RESPONSE.accept(span, res);
                    httpResponse = res;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.setStatus(Status.UNKNOWN.withDescription(t.getMessage()));
                        LOG.log(Level.WARNING, "Unable to execute request: " + t.getMessage(), t);
                        throw t;
                    }
                }
                scope.close();
            }
            return httpResponse;
        }
        finally {
            span.end();
        }
    }
}

