/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.util.concurrent.Callable;

public class TracedCallable<T>
implements Callable<T> {
    private final Tracer tracer;
    private final Span span;
    private final Callable<T> delegate;

    public TracedCallable(Tracer tracer, Span span, Callable<T> delegate) {
        this.tracer = tracer;
        this.span = span;
        this.delegate = delegate;
    }

    @Override
    public T call() throws Exception {
        try (Scope scope = this.tracer.withSpan(this.span);){
            T t = this.delegate.call();
            return t;
        }
    }
}

