/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

public class TracedCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private final CommandExecutor delegate;
    private final Tracer tracer;

    public TracedCommandExecutor(CommandExecutor delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        try (Span commandSpan = this.tracer.getCurrentContext().createSpan("command");){
            SessionId sessionId = command.getSessionId();
            if (sessionId != null) {
                commandSpan.setAttribute("sessionId", sessionId.toString());
            }
            commandSpan.setAttribute("command", command.getName());
            Map<String, ?> parameters = command.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry entry : parameters.entrySet()) {
                    commandSpan.setAttribute("parameter." + (String)entry.getKey(), Objects.toString(entry.getValue(), "null"));
                }
            }
            Response response = this.delegate.execute(command);
            return response;
        }
    }

    public void setLocalLogs(LocalLogs logs) {
        if (this.delegate instanceof NeedsLocalLogs) {
            ((NeedsLocalLogs)this.delegate).setLocalLogs(logs);
        }
    }
}

