/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteScript
extends WebDriverHandler
implements JsonParametersAware {
    private Response response;
    private String script;
    private List<Object> args = new ArrayList<Object>();

    public ExecuteScript(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(List<Object> allParameters) throws Exception {
        this.script = (String)allParameters.get(0);
        if (allParameters.size() == 1) {
            return;
        }
        List params = (List)allParameters.get(1);
        this.parseParams(params, this.args);
    }

    private void parseParams(List<?> params, List<Object> args) {
        for (Object param : params) {
            if (param instanceof Map) {
                Map paramAsMap = (Map)param;
                String type = (String)paramAsMap.get("type");
                if ("ELEMENT".equals(type)) {
                    KnownElements.ProxiedElement element = (KnownElements.ProxiedElement)this.getKnownElements().get((String)paramAsMap.get("value"));
                    args.add(element.getWrappedElement());
                    continue;
                }
                args.add(paramAsMap.get("value"));
                continue;
            }
            if (!(param instanceof List)) continue;
            ArrayList<Object> sublist = new ArrayList<Object>();
            this.parseParams((List)param, sublist);
            args.add(sublist);
        }
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        Object value = this.args.size() > 0 ? ((JavascriptExecutor)this.getDriver()).executeScript(this.script, this.args.toArray()) : ((JavascriptExecutor)this.getDriver()).executeScript(this.script, new Object[0]);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (value == null) {
            result.put("type", "NULL");
        } else if (value instanceof WebElement) {
            String elementId = this.getKnownElements().add((WebElement)value);
            result.put("type", "ELEMENT");
            result.put("value", String.format("element/%s", elementId));
        } else {
            result.put("type", "VALUE");
            result.put("value", value);
        }
        this.response.setValue(result);
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[execute script: %s, %s]", this.script, this.args);
    }
}

