/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserOptions {
    private static final String OPTIONS_SET = "optionsSet";

    private BrowserOptions() {
    }

    public static Capabilities newBrowserOptions() {
        DesiredCapabilities caps = new DesiredCapabilities();
        return Proxies.setProxyRequired((Capabilities)caps, (boolean)true);
    }

    public static Capabilities newBrowserOptions(String browserConfiguration) {
        DesiredCapabilities caps = BrowserOptions.buildFromSemiColonSeparatedOptions(browserConfiguration);
        Capabilities toReturn = Proxies.setProxyRequired((Capabilities)caps, (boolean)true);
        return toReturn;
    }

    private static DesiredCapabilities buildFromSemiColonSeparatedOptions(String browserConfiguration) {
        String[] optionsPairList;
        DesiredCapabilities caps = new DesiredCapabilities();
        for (String anOptionsPairList : optionsPairList = browserConfiguration.split(";")) {
            String[] option = anOptionsPairList.split("=", 2);
            if (2 != option.length) continue;
            String optionsName = option[0].trim();
            String optionValue = option[1].trim();
            caps.setCapability(optionsName, optionValue);
            caps.setCapability(OPTIONS_SET, true);
        }
        return caps;
    }

    public static boolean isSingleWindow(Capabilities capabilities) {
        return capabilities.is("singleWindow");
    }

    public static String getExecutablePath(Capabilities capabilities) {
        return (String)capabilities.getCapability("executablePath");
    }

    public static String getProfile(Capabilities capabilities) {
        return (String)capabilities.getCapability("profile");
    }

    public static String getCommandLineFlags(Capabilities capabilities) {
        return (String)capabilities.getCapability("commandLineFlags");
    }

    public static boolean isTimeoutSet(Capabilities capabilities) {
        return BrowserOptions.getTimeoutInSeconds(capabilities) != 0L;
    }

    public static long getTimeoutInSeconds(Capabilities capabilities) {
        Object value = capabilities.getCapability("timeoutInSeconds");
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(String.valueOf(value));
    }

    public static boolean hasOptionsSet(Capabilities caps) {
        boolean options = false;
        options |= BrowserOptions.isSingleWindow(caps);
        options |= BrowserOptions.getExecutablePath(caps) != null;
        return options |= caps.is(OPTIONS_SET);
    }

    public static Capabilities setSingleWindow(Capabilities source, boolean singleWindow) {
        DesiredCapabilities toReturn = BrowserOptions.newDesiredCapabilities(source);
        toReturn.setCapability("singleWindow", singleWindow);
        return toReturn;
    }

    public static Capabilities setExecutablePath(Capabilities source, String executablePath) {
        DesiredCapabilities toReturn = BrowserOptions.newDesiredCapabilities(source);
        toReturn.setCapability("executablePath", executablePath);
        return toReturn;
    }

    private static DesiredCapabilities newDesiredCapabilities(Capabilities source) {
        if (source instanceof DesiredCapabilities) {
            return (DesiredCapabilities)source;
        }
        return new DesiredCapabilities(source);
    }

    public static File getFile(Capabilities capabilities, String key) {
        Object value = capabilities.getCapability(key);
        if (value == null) {
            return null;
        }
        if (value instanceof File) {
            return (File)value;
        }
        return new File(String.valueOf(value));
    }
}

