/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.lang.reflect.Method;
import java.util.Map;
import org.openqa.selenium.server.browserlaunchers.ProcessorFragment;

class ProcessorCommands {
    Map<String, Class<?>> commandsToResultTypes = Maps.newHashMap();
    Map<Class<?>, ProcessorFragment> commandHandlers = Maps.newHashMap();

    public ProcessorCommands() {
        for (Method method : Selenium.class.getMethods()) {
            this.commandsToResultTypes.put(method.getName(), method.getReturnType());
        }
        this.commandHandlers.put(Boolean.TYPE, new ProcessorFragment(){

            @Override
            public String execute(CommandProcessor processor, String commandName, String[] args) {
                boolean value = processor.getBoolean(commandName, args);
                return String.valueOf(value);
            }
        });
        this.commandHandlers.put(Number.class, new ProcessorFragment(){

            @Override
            public String execute(CommandProcessor processor, String commandName, String[] args) {
                Number value = processor.getNumber(commandName, args);
                return String.valueOf(value);
            }
        });
        this.commandHandlers.put(String.class, new ProcessorFragment(){

            @Override
            public String execute(CommandProcessor processor, String commandName, String[] args) {
                return processor.getString(commandName, args);
            }
        });
        this.commandHandlers.put(String[].class, new ProcessorFragment(){

            @Override
            public String execute(CommandProcessor processor, String commandName, String[] args) {
                Object[] value = processor.getStringArray(commandName, args);
                return Joiner.on((String)",").join(value);
            }
        });
        this.commandHandlers.put(Void.TYPE, new ProcessorFragment(){

            @Override
            public String execute(CommandProcessor processor, String commandName, String[] args) {
                processor.doCommand(commandName, args);
                return null;
            }
        });
    }

    public String execute(CommandProcessor processor, String command, String[] args) {
        Class<?> returnType = this.commandsToResultTypes.get(command);
        if (returnType == null) {
            throw new SeleniumException("Method is not present on Selenium interface: " + command);
        }
        ProcessorFragment fragment = this.commandHandlers.get(returnType);
        return fragment.execute(processor, command, args);
    }
}

