/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.demork;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticdesktop.demork.Utils;
import org.semanticdesktop.demork.XMLOut;
import org.semanticdesktop.demork.database.Cell;
import org.semanticdesktop.demork.database.Database;
import org.semanticdesktop.demork.database.Row;
import org.semanticdesktop.demork.database.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Demork {
    private Charset charset;
    private static Hashtable<String, String> backslash = new Hashtable();

    public String getEncoding(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        byte[] byArray = new byte[150];
        fileInputStream.read(byArray);
        fileInputStream.close();
        String string2 = new String(byArray);
        return this.getEncodingFromHeader(string2);
    }

    private String getEncodingFromHeader(String string) throws Exception {
        Matcher matcher = Pattern.compile("\\(f=(.*)\\)").matcher(string);
        if (matcher == null || !matcher.find()) {
            throw new Exception("Could not find encoding info in mork header.");
        }
        return matcher.group(1);
    }

    public Database inputMork(String string) {
        string = string.replaceFirst("//.*", "");
        try {
            this.charset = Charset.forName(this.getEncodingFromHeader(string));
        }
        catch (Exception exception) {
            this.charset = Charset.defaultCharset();
        }
        string = string.replaceAll("(\\\\(?:\\r|\\n))", "");
        string = string.replaceAll("(\\n\\s*)|(\\r\\s*)|(\\r\\n\\s*)", "");
        Database database = new Database();
        Pattern pattern = Pattern.compile("^\\s+");
        Pattern pattern2 = Pattern.compile("^<\\s*<\\(a=c\\)>\\s*(?:\\/\\/)?\\s*(\\(.+?\\))\\s*>");
        Pattern pattern3 = Pattern.compile("(\\(.+?\\))");
        Pattern pattern4 = Pattern.compile("^<\\s*(\\(.+?\\))\\s*>");
        Pattern pattern5 = Pattern.compile("^@\\$\\$\\{.+?\\{\\@");
        Pattern pattern6 = Pattern.compile("^@\\$\\$\\}.+?\\}\\@");
        Pattern pattern7 = Pattern.compile("^\\{-?(\\d+):\\^(..)\\s*\\{\\(k\\^(..):c\\)\\(s=9u?\\)\\s*(.*?)\\}\\s*(.+?)\\}");
        Pattern pattern8 = Pattern.compile("(-?)\\s*\\[(.+?)((\\(.+?\\)\\s*)*)\\]");
        string = this.myEscapedata(string);
        int n = 0;
        int n2 = string.length();
        Matcher matcher = null;
        boolean bl = false;
        block2: while (true) {
            Object object;
            Object object2;
            if (matcher != null) {
                n += matcher.group().length();
            }
            if (n >= n2) break;
            String string2 = string.substring(n);
            matcher = pattern.matcher(string2);
            if (matcher.find()) {
                n += matcher.group().length();
                continue;
            }
            matcher = null;
            matcher = pattern2.matcher(string2);
            if (matcher.find()) {
                object2 = this.findall(pattern3, matcher.group());
                if (object2.size() >= 2 && ((String)object2.get(1)).indexOf("(f=") == 0) {
                    object2 = object2.subList(1, object2.size());
                }
                if (object2.size() <= 1) continue;
                this.addToDict(database.cdict, object2.subList(1, object2.size()));
                continue;
            }
            matcher = null;
            matcher = pattern4.matcher(string2);
            if (matcher.find()) {
                this.addToDict(database.adict, this.findall(pattern3, matcher.group()));
                continue;
            }
            matcher = null;
            matcher = pattern7.matcher(string2);
            if (matcher.find()) {
                object2 = matcher.group(1) + ':' + matcher.group(2);
                if (database.tables.containsKey(object2)) {
                    object = database.tables.get(object2);
                } else {
                    object = new Table();
                    ((Table)object).id = matcher.group(1);
                    ((Table)object).scope = database.cdict.get(matcher.group(2));
                    ((Table)object).kind = database.cdict.get(matcher.group(3));
                    database.tables.put((String)object2, (Table)object);
                }
                Vector<Vector<String>> vector = this.findallM(pattern8, matcher.group());
                Iterator<Vector<String>> iterator = vector.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Vector<String> vector2 = iterator.next();
                    Vector<String> vector3 = this.findall(pattern3, vector2.get(2));
                    String string3 = vector2.get(1);
                    if (bl && string3.equals("-")) {
                        string3 = string3.substring(1, string3.length());
                        this.delRow(database, database.tables.get(object2), string3);
                    }
                    if (bl && !string3.equals("-")) continue;
                    this.addRow(database, database.tables.get(object2), string3, vector3);
                }
            }
            matcher = null;
            matcher = pattern5.matcher(string2);
            if (matcher.find()) {
                bl = true;
                continue;
            }
            matcher = null;
            matcher = pattern6.matcher(string2);
            if (matcher.find()) {
                bl = false;
                continue;
            }
            matcher = null;
            matcher = pattern8.matcher(string2);
            if (matcher.find() && bl) {
                object2 = matcher.group(2);
                if (((String)object2).charAt(0) == '-') {
                    object2 = ((String)object2).substring(1, ((String)object2).length());
                }
                object = this.findall(pattern3, matcher.group(3));
                this.delRow(database, database.tables.get("1:80"), (String)object2);
                if (((String)object2).charAt(0) == '-') continue;
                this.addRow(database, database.tables.get("1:80"), (String)object2, (Vector<String>)object);
                continue;
            }
            matcher = null;
            System.err.println("ERROR: syntax error while parsing MORK file");
            System.err.println("context[" + n + "]: " + string2.substring(0, Math.min(string2.length(), 40)));
            ++n;
        }
        return database;
    }

    private void addRow(Database database, Table table, String string, Vector<String> vector) {
        Pattern pattern = Pattern.compile("\\^(.+?)=(.*)");
        Pattern pattern2 = Pattern.compile("\\^(.+?)\\^(.+)");
        Row row = new Row();
        String[] stringArray = this.getRowIdScope(string, database.cdict);
        row.id = stringArray[0];
        row.scope = stringArray[1];
        for (String string2 : vector) {
            Cell cell = new Cell();
            Matcher matcher = pattern.matcher(string2 = string2.substring(1, string2.length() - 1));
            if (matcher.find()) {
                cell.column = database.cdict.get(matcher.group(1));
                cell.atom = this.decodeMorkValue(matcher.group(2));
            } else {
                matcher = pattern2.matcher(string2);
                if (matcher.find()) {
                    cell.column = database.cdict.get(matcher.group(1));
                    cell.atom = database.adict.get(matcher.group(2));
                }
            }
            if (cell.column == null || cell.atom == null) continue;
            row.cells.add(cell);
        }
        String string3 = row.scope != null ? row.id + "/" + row.scope : row.id + "/" + table.scope;
        if (table.rows.containsKey(string3)) {
            System.err.println("ERROR: duplicate rowid/scope " + (String)string3);
            System.err.println(vector);
        }
        table.rows.put(string3, row);
    }

    private void delRow(Database database, Table table, String string) {
        String[] stringArray = this.getRowIdScope(string, database.cdict);
        string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = string2 != null ? string + "/" + string2 : string + "/" + table.scope;
        if (table.rows.containsKey(string3)) {
            table.rows.remove(string3);
        }
    }

    private String[] getRowIdScope(String string, Hashtable<String, String> hashtable) {
        int n = string.indexOf(58);
        if (n > 0) {
            return new String[]{string.substring(0, n), hashtable.get(string.substring(n + 2, string.length()))};
        }
        return new String[]{string, null};
    }

    private Vector<Vector<String>> findallM(Pattern pattern, String string) {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            Vector<String> vector2 = new Vector<String>();
            for (int i = 1; i < matcher.groupCount(); ++i) {
                vector2.add(matcher.group(i));
            }
            vector.add(vector2);
        }
        return vector;
    }

    private void addToDict(Hashtable hashtable, List<String> list) {
        for (String string : list) {
            int n = string.indexOf(61);
            String string2 = string.substring(1, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            hashtable.put(string2, this.decodeMorkValue(string3));
        }
    }

    private String myEscapedata(String string) {
        Pattern pattern = Pattern.compile("(\\(.+?\\))");
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group();
            if (string3.equals(string2 = this.escapeData(string3))) continue;
            hashtable.put(string3, string2);
        }
        for (String string2 : hashtable.keySet()) {
            System.err.println("Replacing " + string2 + " with " + (String)hashtable.get(string2));
            string = string.replace(string2, (CharSequence)hashtable.get(string2));
        }
        return string;
    }

    private String escapeData(String string) {
        return string.replace("\\\\n", "$0A").replace("\\)", "$29").replace(">", "$3E").replace("}", "$7D").replace("]", "$5D");
    }

    private String decodeMorkValue(String string) {
        Pattern pattern = Pattern.compile("((?:\\\\[\\$\u0000abtnvfr])|(?:\\$..\\$..))");
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group();
            if (string3.equals(string2 = this.unescapeMork(string3))) continue;
            hashtable.put(string3, string2);
        }
        for (String string2 : hashtable.keySet()) {
            string = string.replace(string2, (CharSequence)hashtable.get(string2));
        }
        return string;
    }

    private String unescapeMork(String string) {
        if (string.charAt(0) == '\\') {
            return backslash.get(string);
        }
        System.err.println("Unescape: " + string.substring(1, Math.min(string.length(), 10)));
        System.err.println(string.substring(1, 3) + " - " + string.substring(4, 6));
        int n = Integer.parseInt(string.substring(1, 3), 16);
        int n2 = Integer.parseInt(string.substring(4, 6), 16);
        return this.chr(n, n2, this.charset);
    }

    private String chr(int n, int n2, Charset charset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put((byte)n);
        byteBuffer.put((byte)n2);
        charset = Charset.forName("utf-8");
        String string = new String(charset.decode(byteBuffer).array());
        return string;
    }

    private static String chr(int n) {
        return Character.toString(Character.forDigit(n, 10));
    }

    private Vector<String> findall(Pattern pattern, String string) {
        Vector<String> vector = new Vector<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            vector.add(matcher.group());
        }
        return vector;
    }

    public static void main(String[] stringArray) throws Exception {
        Demork demork;
        String string;
        String string2;
        String string3;
        if (stringArray.length == 0) {
            System.err.println("Usage: java Demork <morkfile>");
            System.exit(-1);
        }
        if ((string3 = Utils.readWholeFileAsEncoding(string2 = stringArray[0], string = (demork = new Demork()).getEncoding(string2))).indexOf("<mdb:mork") != -1) {
            System.err.println("parsing...");
            Database database = demork.inputMork(string3);
            System.err.println("Result:");
            System.err.println(XMLOut.outPut(database));
        } else {
            System.err.println("unknown file format: " + string2 + " (I only deal with Mork, sorry)");
            System.exit(-1);
        }
    }

    static {
        backslash.put("\\\\", "\\");
        backslash.put("\\$", "$");
        backslash.put("\\0", Demork.chr(0));
        backslash.put("\\a", Demork.chr(7));
        backslash.put("\\b", Demork.chr(8));
        backslash.put("\\t", Demork.chr(9));
        backslash.put("\\n", Demork.chr(10));
        backslash.put("\\v", Demork.chr(11));
        backslash.put("\\f", Demork.chr(12));
        backslash.put("\\r", Demork.chr(13));
    }
}

