/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import junit.framework.TestCase;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.trix.TriXWriter;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.SemanticViewSpecification;
import org.semanticdesktop.nepomuk.openrdf.UnionMemoryStore;

public class BasicInferenceTest
extends TestCase {
    URI claudia = new URIImpl("urn:claudia");
    URI dirk = new URIImpl("urn:dirk");
    URI property = new URIImpl("http://example.org/inv");
    URI a = new URIImpl("http://example.org/a");
    URI b = new URIImpl("http://example.org/b");
    URI c = new URIImpl("http://example.org/c");
    URI p = new URIImpl("http://example.org/p");
    URI p2 = new URIImpl("http://example.org/p2");
    URI context = new URIImpl("http://example.org/context");
    URI basegraph = new URIImpl("http://example.org/base");
    URI infgraph = new URIImpl("http://example.org/inf");
    URI ambrosia = new URIImpl("urn:ambrosia");
    URI keith = new URIImpl("urn:keith");
    URI graph1 = new URIImpl("urn:graph1");
    URI graph2 = new URIImpl("urn:graph2");
    URI graph3 = new URIImpl("urn:graph3");
    private InfSail infsail;
    private MemoryStore base;
    private SailRepository repo;
    private SailRepositoryConnection con;

    protected void setUp() throws Exception {
        super.setUp();
        this.base = new MemoryStore();
        File f = File.createTempFile("nrl", "test");
        f.delete();
        f.deleteOnExit();
        this.infsail = new InfSail((Sail)new UnionMemoryStore());
        this.repo = new SailRepository((Sail)this.infsail);
        this.repo.initialize();
        this.con = this.repo.getConnection();
        this.con.setAutoCommit(false);
    }

    private void setup(String rulesFile) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/semanticdesktop/nepomuk/nrl/" + rulesFile);
        List<Rule> rules = Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new InputStreamReader(is))));
        this.infsail.createSemanticView(this.basegraph, this.infgraph, new SemanticViewSpecification("testrules", rules, (URI)new URIImpl("urn:test:rules")));
    }

    public void testBasic() throws Exception {
        this.setup("simplerule.rule");
        this.con.add((Resource)this.claudia, this.property, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        this.infsail.debug();
        this.dump();
        System.err.println(this.con.size(new Resource[0]));
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.property, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain inverse statement ", (boolean)this.con.hasStatement((Resource)this.dirk, this.property, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.claudia, this.property, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.dirk, this.property, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)2L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testDelayed() throws Exception {
        this.con.add((Resource)this.claudia, this.property, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        this.setup("simplerule.rule");
        this.infsail.debug();
        this.dump();
        System.err.println(this.con.size(new Resource[0]));
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.property, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain inverse statement ", (boolean)this.con.hasStatement((Resource)this.dirk, this.property, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.claudia, this.property, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.dirk, this.property, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)2L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void test2Body() throws Exception {
        this.setup("2body.rule");
        this.con.add((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        this.con.add((Resource)this.dirk, RDFS.SUBCLASSOF, (Value)this.ambrosia, new Resource[]{this.basegraph});
        this.con.commit();
        this.infsail.debug();
        BasicInferenceTest.assertTrue((String)"Graph must contain transitive statement ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.ambrosia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.ambrosia, RDFS.SUBCLASSOF, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)3L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testIncrementeal() throws Exception {
        this.setup("2body.rule");
        this.con.add((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.add((Resource)this.dirk, RDFS.SUBCLASSOF, (Value)this.ambrosia, new Resource[]{this.basegraph});
        this.con.add((Resource)this.keith, RDFS.SUBCLASSOF, (Value)this.claudia, new Resource[]{this.basegraph});
        this.con.commit();
        this.infsail.debug();
        BasicInferenceTest.assertTrue((String)"Graph must contain inferred statement ", (boolean)this.con.hasStatement((Resource)this.keith, RDFS.SUBCLASSOF, (Value)this.ambrosia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.ambrosia, RDFS.SUBCLASSOF, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)6L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testTwoRules() throws Exception {
        this.setup("2rules.rule");
        this.con.add((Resource)this.claudia, this.a, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement", (boolean)this.con.hasStatement((Resource)this.claudia, this.a, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain first inferred statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.b, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain second inferred statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.c, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)3L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testAxiom() throws Exception {
        this.setup("axiom.rule");
        BasicInferenceTest.assertTrue((String)"Graph must contain axiom ", (boolean)this.con.hasStatement((Resource)this.a, this.p, (Value)this.b, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)1L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void test2Head() throws Exception {
        this.setup("2head.rule");
        this.con.add((Resource)this.claudia, this.a, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement", (boolean)this.con.hasStatement((Resource)this.claudia, this.a, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain first inferred statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.b, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain second inferred statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.c, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)3L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testDoubleCoRecursion() throws Exception {
        this.setup("corecursion.rule");
        this.con.add((Resource)this.p, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBCLASSOF, new Resource[]{this.basegraph});
        this.con.add((Resource)this.a, this.p, (Value)this.b, new Resource[]{this.basegraph});
        this.con.add((Resource)this.b, this.p, (Value)this.c, new Resource[]{this.basegraph});
        this.con.commit();
        BasicInferenceTest.assertTrue((String)"Graph must contain transitive of superProperty of p statement ", (boolean)this.con.hasStatement((Resource)this.a, RDFS.SUBCLASSOF, (Value)this.c, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain superProperty of p statement ", (boolean)this.con.hasStatement((Resource)this.a, RDFS.SUBCLASSOF, (Value)this.b, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)6L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testAxiomPlusRule() throws Exception {
        this.setup("axiomPlusRule.rule");
        this.con.add((Resource)this.a, RDFS.ISDEFINEDBY, (Value)this.b, new Resource[]{this.basegraph});
        this.con.commit();
        BasicInferenceTest.assertTrue((String)"Graph must contain superProperty of RDFS.isDefinedBy ", (boolean)this.con.hasStatement((Resource)this.a, RDFS.SEEALSO, (Value)this.b, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)3L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testStackedInf() throws Exception {
        this.setup("2rules1.rule");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/semanticdesktop/nepomuk/nrl/2rules2.rule");
        List<Rule> rules = Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new InputStreamReader(is))));
        URIImpl infgraph2 = new URIImpl("http://example.org/inf2");
        this.infsail.createSemanticView(this.infgraph, (URI)infgraph2, new SemanticViewSpecification("testrules", rules, (URI)new URIImpl("urn:test:rules")));
        this.con.add((Resource)this.claudia, this.a, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        this.infsail.debug();
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement", (boolean)this.con.hasStatement((Resource)this.claudia, this.a, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain first inferred statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.b, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain second inferred statement ", (boolean)this.con.hasStatement((Resource)this.claudia, this.c, (Value)this.dirk, false, new Resource[]{infgraph2}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)3L, (long)this.con.size(new Resource[]{infgraph2}));
    }

    public void testUnion() throws Exception {
        this.con.add((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.dirk, new Resource[]{this.graph1});
        this.con.commit();
        this.con.add((Resource)this.dirk, RDFS.SUBCLASSOF, (Value)this.ambrosia, new Resource[]{this.graph2});
        this.con.commit();
        this.infsail.importGraph((Resource)this.basegraph, new Resource[]{this.graph1, this.graph2});
        this.setup("2body.rule");
        this.infsail.debug();
        BasicInferenceTest.assertTrue((String)"Graph must contain transitive statement ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.ambrosia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertTrue((String)"Graph must contain original statement ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.claudia, RDFS.SUBCLASSOF, (Value)this.claudia, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertFalse((String)"Graph must not contain wrong statements ", (boolean)this.con.hasStatement((Resource)this.ambrosia, RDFS.SUBCLASSOF, (Value)this.dirk, false, new Resource[]{this.infgraph}));
        BasicInferenceTest.assertEquals((String)"Graph must be the right size: ", (long)3L, (long)this.con.size(new Resource[]{this.infgraph}));
    }

    public void testRemoveView() throws Exception {
        this.setup("simplerule.rule");
        this.con.add((Resource)this.claudia, this.property, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        this.infsail.debug();
        this.dump();
        this.infsail.removeGraph((Resource)this.infgraph);
        this.infsail.debug();
        this.dump();
        BasicInferenceTest.assertEquals((String)"InfGraph must be empty:", (long)this.con.size(new Resource[]{this.infgraph}), (long)0L);
    }

    public void testRemoveData() throws Exception {
        this.setup("simplerule.rule");
        this.con.add((Resource)this.claudia, this.property, (Value)this.dirk, new Resource[]{this.basegraph});
        this.con.commit();
        this.infsail.debug();
        this.dump();
        try {
            this.infsail.removeGraph((Resource)this.basegraph);
            BasicInferenceTest.fail((String)"We should not be able to remove the basegraph that has a view!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.infsail.removeGraph((Resource)this.infgraph);
        this.infsail.removeGraph((Resource)this.basegraph);
        this.infsail.debug();
        this.dump();
        BasicInferenceTest.assertEquals((String)"InfGraph must be empty:", (long)this.con.size(new Resource[]{this.infgraph}), (long)0L);
        BasicInferenceTest.assertEquals((String)"BaseGraph must be empty:", (long)this.con.size(new Resource[]{this.basegraph}), (long)0L);
    }

    private void dump() throws RepositoryException, RDFHandlerException {
        this.con.export((RDFHandler)new TriXWriter((OutputStream)System.out), new Resource[0]);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.con.close();
        this.repo.shutDown();
    }
}

