/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference.model;

import com.sun.org.apache.xpath.internal.operations.Variable;
import java.util.List;
import java.util.logging.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.semanticdesktop.nepomuk.nrl.inference.BindingEnvironment;
import org.semanticdesktop.nepomuk.nrl.inference.BuiltinRegistry;
import org.semanticdesktop.nepomuk.nrl.inference.RuleContext;
import org.semanticdesktop.nepomuk.nrl.inference.model.Builtin;
import org.semanticdesktop.nepomuk.nrl.inference.model.ClauseEntry;

public class Functor
implements ClauseEntry {
    private static final URI FUNCTOR_DATATYPE = new URIImpl("urn:x-hp-jena:Functor");
    protected String name;
    protected Value[] args;
    protected Builtin implementor;
    protected static Logger logger = Logger.getLogger(Functor.class.getName());

    public Functor(String name, List args) {
        this.name = name;
        this.args = args.toArray(new Value[0]);
    }

    public Functor(String name, Value[] args) {
        this.name = name;
        this.args = args;
    }

    public Functor(String name, List args, BuiltinRegistry registry) {
        this.name = name;
        this.args = args.toArray(new Value[0]);
        this.implementor = registry.getImplementation(name);
    }

    public String getName() {
        return this.name;
    }

    public Value[] getArgs() {
        return this.args;
    }

    public int getArgLength() {
        return this.args.length;
    }

    public boolean isGround() {
        int i = 0;
        while (i < this.args.length) {
            Value n = this.args[i];
            if (n instanceof Variable) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGround(BindingEnvironment env) {
        int i = 0;
        while (i < this.args.length) {
            Value n = this.args[i];
            if (env.getBinding(this.args[i]) instanceof Variable) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean evalAsBodyClause(RuleContext context) {
        if (this.getImplementor() == null) {
            logger.warning("Invoking undefined functor " + this.getName() + " in " + context.getRule().toShortString());
            return false;
        }
        return this.implementor.bodyCall(this.getBoundArgs(context.getEnv()), this.args.length, context);
    }

    public boolean safeEvalAsBodyClause(RuleContext context) {
        if (this.getImplementor() == null) {
            logger.warning("Invoking undefined functor " + this.getName() + " in " + context.getRule().toShortString());
            return false;
        }
        if (this.implementor.isSafe()) {
            return this.implementor.bodyCall(this.getBoundArgs(context.getEnv()), this.args.length, context);
        }
        return false;
    }

    public Value[] getBoundArgs(BindingEnvironment env) {
        Value[] boundargs = new Value[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            boundargs[i] = env.getBinding(this.args[i]);
            ++i;
        }
        return boundargs;
    }

    public Builtin getImplementor() {
        if (this.implementor == null) {
            this.implementor = BuiltinRegistry.theRegistry.getImplementation(this.name);
        }
        return this.implementor;
    }

    public void setImplementor(Builtin implementor) {
        this.implementor = implementor;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.name);
        buff.append("(");
        int i = 0;
        while (i < this.args.length) {
            buff.append(this.args[i]);
            if (i < this.args.length - 1) {
                buff.append(" ");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }

    public static boolean isFunctor(Value n) {
        if (n == null) {
            return false;
        }
        return n instanceof Literal && ((Literal)n).getDatatype() == FUNCTOR_DATATYPE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Functor) {
            Functor f2 = (Functor)obj;
            if (this.name.equals(f2.name) && this.args.length == f2.args.length) {
                int i = 0;
                while (i < this.args.length) {
                    if (!this.args[i].equals(f2.args[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.args.length << 2;
    }

    public boolean sameAs(Object o) {
        if (o instanceof Functor) {
            Functor f2 = (Functor)o;
            if (this.name.equals(f2.name) && this.args.length == f2.args.length) {
                int i = 0;
                while (i < this.args.length) {
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static Value makeFunctorValue(String name, Value[] args) {
        return Functor.makeFunctorValue(new Functor(name, args));
    }

    public static Value makeFunctorValue(Functor f) {
        return new LiteralImpl(f.name, FUNCTOR_DATATYPE);
    }
}

