/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference.utils;

import java.util.Map;
import org.semanticdesktop.nepomuk.nrl.inference.utils.PrefixMappingImpl;

public interface PrefixMapping {
    public static final PrefixMapping Standard = Factory.create().setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#").setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#").setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#").lock();
    public static final PrefixMapping Extended = Factory.create().setNsPrefixes(Standard).setNsPrefix("eg", "http://www.example.org/").lock();

    public PrefixMapping setNsPrefix(String var1, String var2);

    public PrefixMapping removeNsPrefix(String var1);

    public PrefixMapping setNsPrefixes(PrefixMapping var1);

    public PrefixMapping setNsPrefixes(Map var1);

    public PrefixMapping withDefaultMappings(PrefixMapping var1);

    public String getNsPrefixURI(String var1);

    public String getNsURIPrefix(String var1);

    public Map getNsPrefixMap();

    public String expandPrefix(String var1);

    public String shortForm(String var1);

    public String usePrefix(String var1);

    public String qnameFor(String var1);

    public PrefixMapping lock();

    public boolean samePrefixMappingAs(PrefixMapping var1);

    public static class Factory {
        public static PrefixMapping create() {
            return new PrefixMappingImpl();
        }
    }

    public static class IllegalPrefixException
    extends RuntimeException {
        public IllegalPrefixException(String prefixName) {
            super(prefixName);
        }
    }

    public static class JenaLockedException
    extends RuntimeException {
        public JenaLockedException(PrefixMapping pm) {
            super(pm.toString());
        }
    }
}

