/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailWrapper;
import org.semanticdesktop.nepomuk.nrl.inference.NRL;
import org.semanticdesktop.nepomuk.openrdf.InfSailConnection;
import org.semanticdesktop.nepomuk.openrdf.InfSailException;
import org.semanticdesktop.nepomuk.openrdf.NrlGraphs;
import org.semanticdesktop.nepomuk.openrdf.SemanticViewSpecification;
import org.semanticdesktop.nepomuk.openrdf.UnionMaterialisingMemorySail;
import org.semanticdesktop.nepomuk.openrdf.UnionMaterialisingSail;
import org.semanticdesktop.nepomuk.openrdf.UnionNativeStore;
import org.semanticdesktop.nepomuk.openrdf.UnionRewriteSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailException;
import org.semanticdesktop.nepomuk.openrdf.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfSail
extends SailWrapper {
    private InfSailConnection _connection;
    private Map<Resource, Resource> metaDataGraphs;
    private Map<URI, Set<View>> views;
    private static final boolean DEBUG = false;
    private UnionSail unionsail;
    Logger log = LoggerFactory.getLogger(InfSail.class);

    public InfSail(Sail base) throws SailException {
        super(base);
        if (!(base instanceof UnionSail)) {
            throw new SailException("InfSail must build on top of a unionsail!");
        }
        this.unionsail = (UnionSail)base;
    }

    public static InfSail createInfSail(Object base, UnionStyle style) throws SailException {
        UnionMaterialisingSail unionsail = null;
        switch (style) {
            case MATERIALISE: {
                unionsail = new UnionMaterialisingSail((Sail)base);
                break;
            }
            case MATERIALISE_MEMORY: {
                unionsail = new UnionMaterialisingMemorySail((Sail)base);
                break;
            }
            case REWRITE: {
                unionsail = new UnionRewriteSail((Sail)base);
                break;
            }
            case NATIVE: {
                unionsail = new UnionNativeStore((File)base);
            }
        }
        return new InfSail((Sail)unionsail);
    }

    public SailConnection getConnection() throws SailException {
        return new InfSailConnection(this, this.unionsail.getConnection());
    }

    void addStrata(URI view, URI strata) throws SailException {
        boolean release = this.acquireConnection();
        try {
            this._connection.addStatement((Resource)view, NrlGraphs.HAS_STRATA, (Value)strata, new Resource[]{this.getMetaGraph(view)});
            this._connection.commit();
            this.addUnion((Resource)view, new Resource[]{strata});
        }
        finally {
            if (release) {
                this.releaseConnection();
            }
        }
    }

    private void reIndex() throws SailException {
        URI target;
        Statement s;
        this.unionsail.reset();
        this.metaDataGraphs = new HashMap<Resource, Resource>();
        CloseableIteration si = this._connection.getStatements(null, NRL.imports, null, false, new Resource[0]);
        while (si.hasNext()) {
            s = (Statement)si.next();
            target = (URI)s.getSubject();
            URI uRI = (URI)s.getObject();
        }
        si.close();
        this.views = new HashMap<URI, Set<View>>();
        si = this._connection.getStatements(null, NRL.viewOn, null, false, new Resource[0]);
        while (si.hasNext()) {
            s = (Statement)si.next();
            target = (URI)s.getSubject();
            URI source = (URI)s.getObject();
            if (this.views.containsKey(source)) {
                this.views.get(source).add(new View(target, source, SemanticViewSpecification.getNRL(), this));
            } else {
                HashSet<View> set = new HashSet<View>(1);
                set.add(new View(target, source, SemanticViewSpecification.getNRL(), this));
                this.views.put(source, set);
            }
            this.unionsail.addUnion((Resource)target, new Resource[]{source});
        }
        si.close();
    }

    public void removeGraph(Resource graph) throws SailException {
        this.removeGraph(graph, null);
    }

    public void removeGraph(Resource graph, InfSailConnection connection) throws SailException {
        block12: {
            if (this.unionsail.isInUnion(graph)) {
                throw new InfSailException("You cannot remove a graph that is included in another view/union. At the moment you have to untangel this yourself. Sorry! :)");
            }
            boolean release = false;
            if (connection == null) {
                release = this.acquireConnection();
                connection = this._connection;
            }
            try {
                for (Map.Entry<URI, Set<View>> e : this.views.entrySet()) {
                    for (View v : e.getValue()) {
                        if (v.name != graph) continue;
                        List<URI> s = v.getStratas(this._connection);
                        if (s.size() > 0) {
                            connection.clear((Resource[])s.toArray(new URI[s.size()]));
                        }
                        connection.clear(this.metaDataGraphs.get(e.getKey()));
                        this.metaDataGraphs.remove(e.getKey());
                        this.views.remove(e.getKey());
                    }
                }
                connection.commit();
                if (this.unionsail.isUnion(graph)) {
                    try {
                        this.unionsail.removeUnion(graph);
                        break block12;
                    }
                    catch (UnionSailException e) {
                        throw new InfSailException(e);
                    }
                }
                connection.clear(graph);
                connection.commit();
            }
            finally {
                if (release) {
                    this.releaseConnection();
                }
            }
        }
    }

    public void createSemanticView(URI baseGraph, URI newView, SemanticViewSpecification viewSemantics) throws SailException {
        this.createSemanticView(baseGraph, newView, viewSemantics, null);
    }

    public void createSemanticView(URI baseGraph, URI newView, SemanticViewSpecification viewSemantics, InfSailConnection connection) throws SailException {
        boolean release = false;
        if (connection == null) {
            release = this.acquireConnection();
            connection = this._connection;
        }
        try {
            URI newMeta = this.createMetaDataGraph(newView, NRL.KnowledgeBase, connection);
            connection.addStatement((Resource)newView, NRL.viewOn, (Value)baseGraph, new Resource[]{newMeta});
            connection.addStatement((Resource)newView, NRL.superGraphOf, (Value)baseGraph, new Resource[]{newMeta});
            connection.addStatement((Resource)newView, NRL.hasSemantics, (Value)viewSemantics.uri, new Resource[]{newMeta});
            View view = new View(baseGraph, newView, viewSemantics, this);
            this.addView(view);
            this.addUnion((Resource)newView, new Resource[]{baseGraph});
            connection.reinfer(baseGraph);
            connection.commit();
        }
        finally {
            if (release) {
                this.releaseConnection();
            }
        }
    }

    private void addUnion(Resource target, Resource ... source) {
        this.unionsail.addUnion(target, source);
    }

    private void addView(View view) {
        if (this.views.containsKey(view.base)) {
            this.views.get(view.base).add(view);
        } else {
            HashSet<View> set = new HashSet<View>(1);
            set.add(view);
            this.views.put(view.base, set);
        }
    }

    public void importGraph(Resource target, Resource ... source) throws SailException {
        this.importGraph((InfSailConnection)null, target, source);
    }

    public void importGraph(InfSailConnection connection, Resource target, Resource ... source) throws SailException {
        boolean release = false;
        if (connection == null) {
            release = this.acquireConnection();
            connection = this._connection;
        }
        try {
            this.addUnion(target, source);
        }
        finally {
            if (release) {
                this.releaseConnection();
            }
        }
    }

    private void releaseConnection() throws SailException {
        if (this._connection != null) {
            this._connection.close();
        }
        this._connection = null;
    }

    private boolean acquireConnection() throws SailException {
        if (this._connection == null) {
            this._connection = (InfSailConnection)this.getConnection();
            return true;
        }
        return false;
    }

    private URI createMetaDataGraph(URI graph, URI type, InfSailConnection connection) throws SailException {
        URI res = this.getMetaGraph(graph);
        connection.addStatement((Resource)res, RDF.TYPE, (Value)NRL.GraphMetadata, new Resource[]{res});
        connection.addStatement((Resource)res, NRL.metadataOn, (Value)graph, new Resource[]{res});
        connection.addStatement((Resource)graph, RDF.TYPE, (Value)type, new Resource[]{res});
        this.metaDataGraphs.put((Resource)graph, (Resource)res);
        return res;
    }

    private URI getMetaGraph(URI graph) {
        return new URIImpl("nrlmeta:" + graph.toString());
    }

    public boolean hasView(Resource context) {
        return this.views.containsKey(context);
    }

    public Set<View> getViews(Resource context) {
        return this.views.get(context);
    }

    public void debug() {
        System.err.println("InfGraphs:");
        HashSet<View> allviews = new HashSet<View>();
        for (Set<View> v : this.views.values()) {
            for (View view : v) {
                allviews.add(view);
            }
        }
        for (View view : allviews) {
            System.err.println(view);
        }
        this.unionsail.debug();
    }

    public void initialize() throws SailException {
        super.initialize();
        this.acquireConnection();
        try {
            this.reIndex();
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnionStyle {
        REWRITE,
        MATERIALISE,
        MATERIALISE_MEMORY,
        NATIVE;

    }
}

