/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.semanticdesktop.nepomuk.nrl.inference.NRL;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticViewSpecification {
    private static final String NRL_RULES = "/org/semanticdesktop/nepomuk/nrl/inference/rules/nrl.rules";
    private static final String RDFS_RULES = "/org/semanticdesktop/nepomuk/nrl/inference/rules/rdfs.rules";
    private static List<Rule> nrl_rules;
    private static SemanticViewSpecification nrl;
    private static SemanticViewSpecification rdfs;
    private static List<Rule> rdfs_rules;
    private String name;
    private List<Rule> rules;
    public URI uri;

    public SemanticViewSpecification(String name, List<Rule> rules, URI uri) {
        this.name = name;
        this.rules = rules;
        this.uri = uri;
    }

    public static SemanticViewSpecification getNRL() {
        if (nrl == null) {
            InputStream is = SemanticViewSpecification.class.getResourceAsStream(NRL_RULES);
            nrl_rules = Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new InputStreamReader(is))));
            nrl = new SemanticViewSpecification("NRL", nrl_rules, NRL.NS_NRL_GEN);
        }
        return nrl;
    }

    public static SemanticViewSpecification getRDFS() {
        if (rdfs == null) {
            InputStream is = SemanticViewSpecification.class.getResourceAsStream(RDFS_RULES);
            rdfs_rules = Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new InputStreamReader(is))));
            rdfs = new SemanticViewSpecification("RDFS", rdfs_rules, (URI)new URIImpl("http://www.w3.org/2000/01/rdf-schema#"));
        }
        return nrl;
    }

    public List<Rule> getRules() {
        return this.rules;
    }
}

