/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator.testers;

import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.nepomuk.nrl.validator.ModelTester;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationMessage;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.exception.ModelTesterException;

public class RootElementModelTester
implements ModelTester {
    private static final String NIE_NS = "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#";
    private static final URI NIE_ROOT_ELEMENT_OF = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#rootElementOf");

    public ValidationReport performTests(Model unionModel, Model dataModel) throws ModelTesterException {
        ValidationReport report = new ValidationReport();
        this.performTests(unionModel, dataModel, report);
        return report;
    }

    public void performTests(Model unionModel, Model dataModel, ValidationReport report) throws ModelTesterException {
        ClosableIterator iterator = null;
        try {
            iterator = dataModel.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)NIE_ROOT_ELEMENT_OF, (NodeOrVariable)Variable.ANY);
            if (!iterator.hasNext()) {
                report.addMessage(ValidationMessage.MessageType.ERROR, "ROOT ELEMENTS MISSING", "The data model doesn't contain any root elements", new Statement[]{null});
            }
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

