/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailWrapper;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticdesktop.nepomuk.openrdf.UnionMaterialisingMemorySailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionMaterialisingMemorySail
extends SailWrapper
implements UnionSail {
    private HashMap<Resource, Set<Resource>> unions;
    private HashMap<Resource, Set<Resource>> invunions;
    protected MemoryStore store;

    public UnionMaterialisingMemorySail(Sail base) throws SailException {
        super(base);
        this.reset();
    }

    @Override
    public void reset() throws SailException {
        this.unions = new HashMap();
        this.invunions = new HashMap();
        this.store = new MemoryStore();
        this.store.initialize();
    }

    public void shutDown() throws SailException {
        super.shutDown();
        this.store.shutDown();
    }

    public SailConnection getConnection() throws SailException {
        return new UnionMaterialisingMemorySailConnection(this, super.getConnection(), this.store.getConnection());
    }

    public void initialize() throws SailException {
        super.initialize();
    }

    @Override
    public SailConnection baseGetConnection() throws SailException {
        return this.getBaseSail().getConnection();
    }

    @Override
    public void createUnion(URI new_context, URI ... contexts) throws SailException {
        URI c;
        SailConnection con = this.getConnection();
        SailConnection storecon = this.store.getConnection();
        if (con.size(new Resource[]{new_context}) > 0L) {
            throw new SailException("Attempting to create new union in non-empty context: " + new_context);
        }
        this.unions.put((Resource)new_context, new HashSet(Arrays.asList(contexts)));
        URI[] uRIArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            c = uRIArray[n2];
            if (this.invunions.containsKey(c)) {
                this.invunions.get(c).add((Resource)new_context);
            } else {
                HashSet<URI> set = new HashSet<URI>();
                set.add(new_context);
                this.invunions.put((Resource)c, set);
            }
            ++n2;
        }
        uRIArray = contexts;
        n = contexts.length;
        n2 = 0;
        while (n2 < n) {
            c = uRIArray[n2];
            CloseableIteration r = con.getStatements(null, null, null, false, new Resource[]{c});
            while (r.hasNext()) {
                Statement s = (Statement)r.next();
                storecon.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{new_context});
            }
            r.close();
            ++n2;
        }
        storecon.commit();
        con.close();
        storecon.close();
    }

    public Set<Resource> getUnionContexts(Resource c) {
        if (this.invunions.containsKey(c)) {
            return this.invunions.get(c);
        }
        return null;
    }

    public void dump() throws SailException {
        CloseableIteration i2;
        Resource r;
        System.err.println("Base:");
        SailConnection con = this.baseGetConnection();
        CloseableIteration i = con.getContextIDs();
        while (i.hasNext()) {
            r = (Resource)i.next();
            i2 = con.getStatements(null, null, null, false, new Resource[]{r});
            System.err.println("Context: " + r);
            while (i2.hasNext()) {
                System.err.println(i2.next());
            }
            i2.close();
        }
        i.close();
        con.close();
        System.err.println("MemStore:");
        con = this.store.getConnection();
        i = con.getContextIDs();
        while (i.hasNext()) {
            r = (Resource)i.next();
            i2 = con.getStatements(null, null, null, false, new Resource[]{r});
            System.err.println("Context: " + r);
            while (i2.hasNext()) {
                System.err.println(i2.next());
            }
            i2.close();
        }
        i.close();
        con.close();
    }

    @Override
    public void addUnion(Resource target, Resource ... contexts) {
        if (this.unions.containsKey(target)) {
            Resource[] resourceArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                Resource c = resourceArray[n2];
                this.unions.get(target).add(c);
                ++n2;
            }
        } else {
            HashSet<Resource> set = new HashSet<Resource>();
            Resource[] resourceArray = contexts;
            int n = contexts.length;
            int n3 = 0;
            while (n3 < n) {
                Resource c = resourceArray[n3];
                set.add(c);
                ++n3;
            }
            this.unions.put(target, set);
        }
    }

    @Override
    public boolean isUnion(Resource context) {
        return this.unions.containsKey(context);
    }

    @Override
    public void debug() {
        System.err.println("Unions:");
        for (Map.Entry<Resource, Set<Resource>> e : this.unions.entrySet()) {
            System.err.println(e.getKey() + " => " + e.getValue());
        }
    }

    @Override
    public boolean isInUnion(Resource context) {
        return this.invunions.containsKey(context);
    }

    @Override
    public void removeUnion(Resource target) throws UnionSailException {
        if (this.isInUnion(target)) {
            throw new UnionSailException("Can not delete union that is in another union. Untangle from top please.");
        }
        if (this.isUnion(target)) {
            for (Resource r : this.unions.get(target)) {
                this.invunions.get(r).remove(target);
            }
            this.unions.remove(target);
            try {
                SailConnection c = this.store.getConnection();
                c.clear(new Resource[]{target});
                c.commit();
                c.close();
            }
            catch (SailException e) {
                throw new UnionSailException("Could not clear context: ", e);
            }
        } else {
            throw new UnionSailException("Context " + target + " is not a union");
        }
    }
}

