/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.UnionIteration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailConnectionWrapper;
import org.semanticdesktop.nepomuk.openrdf.UnionMaterialisingMemorySail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionMaterialisingMemorySailConnection
extends SailConnectionWrapper
implements UnionSailConnection {
    private UnionMaterialisingMemorySail sail;
    private SailConnection storeconnection;

    public UnionMaterialisingMemorySailConnection(UnionMaterialisingMemorySail sail, SailConnection wrappedCon, SailConnection storeconnection) {
        super(wrappedCon);
        this.sail = sail;
        this.storeconnection = storeconnection;
    }

    public void close() throws SailException {
        super.close();
        this.storeconnection.close();
    }

    public void commit() throws SailException {
        super.commit();
        this.storeconnection.commit();
    }

    public void rollback() throws SailException {
        super.rollback();
        this.storeconnection.rollback();
    }

    @Override
    public long realSize(Resource context) throws SailException {
        return super.size(context);
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            if (this.sail.isUnion(c)) {
                throw new SailException("Cannot add to union model: " + c);
            }
            Set<Resource> unions = this.sail.getUnionContexts(c);
            if (unions != null) {
                for (Resource u : unions) {
                    this.addStoreStatement(subj, pred, obj, u);
                }
            }
            ++n2;
        }
    }

    private void addStoreStatement(Resource subj, URI pred, Value obj, Resource context) throws SailException {
        this.storeconnection.addStatement(subj, pred, obj, new Resource[]{context});
        Set<Resource> unions = this.sail.getUnionContexts(context);
        if (unions != null) {
            for (Resource u : unions) {
                this.addStoreStatement(subj, pred, obj, u);
            }
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            if (this.sail.isUnion(c)) {
                throw new SailException("Cannot delete from union model: " + c);
            }
            Set<Resource> unions = this.sail.getUnionContexts(c);
            if (unions != null) {
                for (Resource u : unions) {
                    CloseableIteration<? extends Statement, SailException> st = this.getStatements(null, null, null, false, u);
                    while (st.hasNext()) {
                        Statement s = (Statement)st.next();
                        this.removeStoreStatement(s.getSubject(), s.getPredicate(), s.getObject(), u);
                    }
                    st.close();
                }
            }
            ++n2;
        }
        super.clear(contexts);
    }

    private void removeStoreStatement(Resource subj, URI pred, Value obj, Resource context) throws SailException {
        this.storeconnection.removeStatements(subj, pred, obj, new Resource[]{context});
        Set<Resource> unions = this.sail.getUnionContexts(context);
        if (unions != null) {
            for (Resource u : unions) {
                this.removeStoreStatement(subj, pred, obj, u);
            }
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, BindingSet bindings, boolean includeInferred) throws SailException {
        if (this.isUnion((QueryModelNode)tupleExpr, bindings)) {
            return this.storeconnection.evaluate(tupleExpr, bindings, includeInferred);
        }
        return super.evaluate(tupleExpr, bindings, includeInferred);
    }

    private boolean isUnion(QueryModelNode query, BindingSet bs) throws UnionSailException {
        Object res = null;
        if (query instanceof Projection) {
            Projection p = (Projection)query;
            return this.isUnion((QueryModelNode)p.getArg(), bs);
        }
        if (query instanceof StatementPattern) {
            StatementPattern st = (StatementPattern)query;
            switch (st.getScope()) {
                case NAMED_CONTEXTS: {
                    Var c = st.getContextVar();
                    System.out.println(c);
                    if (!c.hasValue()) {
                        throw new UnionSailException("This query is too complicated for the UnionSail, I cannot handle GRAPH variables.");
                    }
                    return this.sail.isUnion((Resource)c.getValue());
                }
                case ALL_CONTEXTS: {
                    return false;
                }
                case NULL_CONTEXT: {
                    return false;
                }
            }
        } else {
            if (query instanceof Join) {
                Join j = (Join)query;
                boolean left = this.isUnion((QueryModelNode)j.getLeftArg(), bs);
                boolean right = this.isUnion((QueryModelNode)j.getRightArg(), bs);
                if (left && right) {
                    return true;
                }
                if (!left && !right) {
                    return false;
                }
                throw new UnionSailException("Query Join combines Union and non-union contexts. This is not supported. Sorry. ");
            }
            throw new RuntimeException("Support for " + query.getClass() + " type query elements is not programmed yet. I suck. Sorry. ");
        }
        throw new RuntimeException("Stupid eclipse doesn't realise we can never get here. ");
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        return new UnionIteration(new Iteration[]{super.getContextIDs(), this.storeconnection.getContextIDs()});
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean useInference, Resource ... contexts) throws SailException {
        if (contexts.length == 0) {
            return new UnionIteration(new Iteration[]{super.getStatements(subj, pred, obj, useInference, new Resource[0]), this.storeconnection.getStatements(subj, pred, obj, useInference, new Resource[0])});
        }
        Vector<Resource> plaincontexts = new Vector<Resource>((Collection)Arrays.asList(contexts));
        List<Resource> unioncontexts = this.splitContexts(plaincontexts);
        if (plaincontexts.isEmpty()) {
            if (unioncontexts.isEmpty()) {
                throw new SailException("Both context lists empty after split. Programmer error. ");
            }
            return this.storeconnection.getStatements(subj, pred, obj, useInference, this.toArray(unioncontexts));
        }
        if (unioncontexts.isEmpty()) {
            return super.getStatements(subj, pred, obj, useInference, this.toArray(plaincontexts));
        }
        return new UnionIteration(new Iteration[]{super.getStatements(subj, pred, obj, useInference, this.toArray(plaincontexts)), this.storeconnection.getStatements(subj, pred, obj, useInference, this.toArray(unioncontexts))});
    }

    private Resource[] toArray(List<Resource> contexts) {
        return contexts.toArray(new Resource[contexts.size()]);
    }

    private List<Resource> splitContexts(List<Resource> plaincontexts) {
        Vector<Resource> unioncontexts = new Vector<Resource>();
        Iterator<Resource> i = plaincontexts.iterator();
        while (i.hasNext()) {
            Resource c = i.next();
            if (!this.sail.isUnion(c)) continue;
            i.remove();
            unioncontexts.add(c);
        }
        return unioncontexts;
    }

    public long size(Resource ... contexts) throws SailException {
        if (contexts.length == 0) {
            return super.size(new Resource[0]) + this.storeconnection.size(new Resource[0]);
        }
        Vector<Resource> plaincontexts = new Vector<Resource>((Collection)Arrays.asList(contexts));
        List<Resource> unioncontexts = this.splitContexts(plaincontexts);
        if (plaincontexts.isEmpty()) {
            if (unioncontexts.isEmpty()) {
                throw new SailException("Both context lists empty after split. Programmer error. ");
            }
            return this.storeconnection.size(this.toArray(unioncontexts));
        }
        if (unioncontexts.isEmpty()) {
            return super.size(this.toArray(plaincontexts));
        }
        return super.size(this.toArray(plaincontexts)) + this.storeconnection.size(this.toArray(unioncontexts));
    }

    public long size(Resource context) throws SailException {
        if (this.sail.isUnion(context)) {
            return this.storeconnection.size(new Resource[]{context});
        }
        return super.size(context);
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            if (this.sail.isUnion(c)) {
                throw new SailException("Cannot delete from union model: " + c);
            }
            Set<Resource> unions = this.sail.getUnionContexts(c);
            if (unions != null) {
                for (Resource u : unions) {
                    this.storeconnection.removeStatements(subj, pred, obj, new Resource[]{u});
                }
            }
            ++n2;
        }
    }
}

