/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LockingIteration;
import java.io.IOException;
import java.util.Comparator;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BooleanExprOptimizer;
import org.openrdf.query.algebra.evaluation.impl.CostComparator;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeStoreConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionNativeStore;
import org.semanticdesktop.nepomuk.openrdf.UnionNativeTripleSource;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionNativeStoreConnection
extends NativeStoreConnection
implements SailConnection,
UnionSailConnection {
    private UnionNativeStore unionNativeStore;

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, BindingSet bindings, boolean includeInferred) throws SailException {
        Lock readLock = this.unionNativeStore.getReadLock();
        try {
            this.replaceValues(tupleExpr);
            UnionNativeTripleSource tripleSource = new UnionNativeTripleSource(this.unionNativeStore, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource);
            QueryJoinOptimizer joinOptimizer = new QueryJoinOptimizer((Comparator)new CostComparator());
            joinOptimizer.optimize(tupleExpr, EmptyBindingSet.getInstance());
            BooleanExprOptimizer booleanExprOptimizer = new BooleanExprOptimizer((EvaluationStrategy)strategy);
            booleanExprOptimizer.optimize(tupleExpr, EmptyBindingSet.getInstance());
            CloseableIteration iter = null;
            try {
                iter = strategy.evaluate(tupleExpr, bindings);
            }
            catch (QueryEvaluationException e) {
                throw new SailException((Throwable)e);
            }
            return new LockingIteration(readLock, (Iteration)iter);
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        UnionNativeTripleSource nts = new UnionNativeTripleSource(this.unionNativeStore, true);
        Lock readLock = this.unionNativeStore.getReadLock();
        try {
            Object stIter = nts.getStatementsSailException(null, null, null, new Resource[0]);
            stIter = new FilterIteration<Statement, SailException>((Iteration)stIter){

                protected boolean accept(Statement st) {
                    return st.getContext() != null;
                }
            };
            return new LockingIteration(readLock, (Iteration)new DistinctIteration((Iteration)new ConvertingIteration<Statement, Resource, SailException>((Iteration)stIter){

                protected Resource convert(Statement st) {
                    return st.getContext();
                }
            }));
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        UnionNativeTripleSource nts = new UnionNativeTripleSource(this.unionNativeStore, includeInferred);
        Lock readLock = this.unionNativeStore.getReadLock();
        try {
            return new LockingIteration(readLock, (Iteration)nts.getStatementsSailException(subj, pred, obj, contexts));
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    public UnionNativeStoreConnection(UnionNativeStore nativeStore) throws IOException {
        super((NativeStore)nativeStore);
        this.unionNativeStore = nativeStore;
    }

    @Override
    public long realSize(Resource context) throws SailException {
        return super.size(new Resource[]{context});
    }
}

