/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.collections.iterators.FilterIterator;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeTripleSource;
import org.semanticdesktop.nepomuk.openrdf.UnionNativeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionNativeTripleSource
extends NativeTripleSource
implements TripleSource {
    private UnionNativeStore unionStore;

    UnionNativeTripleSource(UnionNativeStore store, boolean includeInferred) {
        super((NativeStore)store, includeInferred);
        this.unionStore = store;
    }

    protected CloseableIteration<? extends Statement, IOException> getStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) {
        if (contexts.length == 0) {
            return new MagicIteration(subj, pred, obj, this.unionStore.unions.entrySet().iterator(), true);
        }
        if (contexts.length == 1) {
            return new IterationContextConverter((CloseableIteration<? extends Statement, ? extends IOException>)super.getStatementsInternal(subj, pred, obj, this.expandContext(contexts)), contexts[0]);
        }
        final HashSet contextSet = new HashSet();
        contextSet.addAll(Arrays.asList(contexts));
        FilterIterator<Map.Entry<Resource, Set<Resource>>> filteredIt = new FilterIterator<Map.Entry<Resource, Set<Resource>>>(this.unionStore.unions.entrySet().iterator()){

            protected boolean accept(Map.Entry<Resource, Set<Resource>> e) throws RuntimeException {
                return contextSet.contains(e.getKey());
            }
        };
        return new MagicIteration(subj, pred, obj, (Iterator<Map.Entry<Resource, Set<Resource>>>)filteredIt, false);
    }

    private Resource[] expandContext(Resource ... contexts) {
        HashSet<Resource> res = new HashSet<Resource>();
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (this.unionStore.unions.containsKey(r)) {
                res.addAll((Collection)Arrays.asList(this.expandContext((Collection<? extends Resource>)this.unionStore.unions.get(r))));
            }
            res.add(r);
            ++n2;
        }
        return res.toArray(new Resource[res.size()]);
    }

    private Resource[] expandContext(Collection<? extends Resource> contexts) {
        HashSet<Resource> res = new HashSet<Resource>();
        for (Resource resource : contexts) {
            if (this.unionStore.unions.containsKey(resource)) {
                res.addAll((Collection)Arrays.asList(this.expandContext((Collection<? extends Resource>)this.unionStore.unions.get(resource))));
                continue;
            }
            res.add(resource);
        }
        return res.toArray(new Resource[res.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterationContextConverter
    implements CloseableIteration<Statement, IOException> {
        private CloseableIteration<? extends Statement, ? extends IOException> base;
        private Resource newr;
        private ValueFactory vf;

        public IterationContextConverter(CloseableIteration<? extends Statement, ? extends IOException> name, Resource newr) {
            this.base = name;
            this.newr = newr;
            this.vf = UnionNativeTripleSource.this.getValueFactory();
        }

        public void close() throws IOException {
            this.base.close();
        }

        public boolean hasNext() throws IOException {
            return this.base.hasNext();
        }

        public Statement next() throws IOException {
            Statement s = (Statement)this.base.next();
            return this.vf.createStatement(s.getSubject(), s.getPredicate(), s.getObject(), this.newr);
        }

        public void remove() throws IOException {
            this.base.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MagicIteration
    implements CloseableIteration<Statement, IOException> {
        private Iterator<Map.Entry<Resource, Set<Resource>>> unions;
        private Value obj;
        private URI pred;
        private Resource subj;
        private CloseableIteration<? extends Statement, IOException> current;
        Resource targetContext;
        private Iterator<Map.Entry<Resource, Set<Resource>>> eit;
        private ValueFactory vf;

        public MagicIteration(Resource subj, URI pred, Value obj, Iterator<Map.Entry<Resource, Set<Resource>>> unions, boolean doAll) {
            this.vf = UnionNativeTripleSource.this.getValueFactory();
            this.subj = subj;
            this.pred = pred;
            this.obj = obj;
            this.unions = unions;
            this.current = doAll ? UnionNativeTripleSource.super.getStatementsInternal(subj, pred, obj, new Resource[0]) : new EmptyIteration();
            this.targetContext = null;
        }

        public void close() throws IOException {
            this.current.close();
        }

        public boolean hasNext() throws IOException {
            boolean r = this.current.hasNext();
            if (!r) {
                if (this.unions.hasNext()) {
                    Map.Entry<Resource, Set<Resource>> e = this.unions.next();
                    long start = System.currentTimeMillis();
                    Resource[] c = UnionNativeTripleSource.this.expandContext(e.getValue());
                    this.current = UnionNativeTripleSource.super.getStatementsInternal(this.subj, this.pred, this.obj, c);
                    this.targetContext = e.getKey();
                    return this.hasNext();
                }
                return false;
            }
            return r;
        }

        public Statement next() throws IOException {
            if (this.targetContext == null) {
                return (Statement)this.current.next();
            }
            Statement s = (Statement)this.current.next();
            return new ContextStatementImpl(s.getSubject(), s.getPredicate(), s.getObject(), this.targetContext);
        }

        public void remove() throws IOException {
            this.current.remove();
        }
    }
}

