/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Selection;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailConnectionWrapper;
import org.semanticdesktop.nepomuk.openrdf.UnionRewriteSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionRewriteSailConnection
extends SailConnectionWrapper
implements SailConnection,
UnionSailConnection {
    protected UnionRewriteSail sail;
    private int unionVarCount = 0;
    private int unionConstCount = 0;

    public long size(Resource ... contexts) throws SailException {
        Resource[] allcontexts = this.expandContext(contexts);
        return super.size(allcontexts);
    }

    public long size(Resource context) throws SailException {
        Resource[] allcontexts = this.expandContext(context);
        return super.size(allcontexts);
    }

    @Override
    public long realSize(Resource context) throws SailException {
        return super.size(context);
    }

    public UnionRewriteSailConnection(UnionRewriteSail sail, SailConnection connection) {
        super(connection);
        this.sail = sail;
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.checkNotIn(contexts, this.sail.unions);
        super.addStatement(subj, pred, obj, contexts);
    }

    private boolean checkNotIn(Resource[] contexts, HashMap<Resource, Set<Resource>> unions) throws UnionSailException {
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (unions.containsKey(r)) {
                throw new UnionSailException("Cannot write to union-sail " + r);
            }
            ++n2;
        }
        return false;
    }

    public void clear(Resource ... contexts) throws SailException {
        this.checkNotIn(contexts, this.sail.unions);
        super.clear(contexts);
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInf, Resource ... contexts) throws SailException {
        Resource[] allcontexts = this.expandContext(contexts);
        return super.getStatements(subj, pred, obj, includeInf, allcontexts);
    }

    private Resource[] expandContext(Resource ... contexts) {
        HashSet<Resource> res = new HashSet<Resource>();
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (this.sail.unions.containsKey(r)) {
                res.addAll((Collection)Arrays.asList(this.expandContext((Collection<? extends Resource>)this.sail.unions.get(r))));
            }
            res.add(r);
            ++n2;
        }
        return res.toArray(new Resource[res.size()]);
    }

    private Resource[] expandContext(Collection<? extends Resource> contexts) {
        HashSet<Resource> res = new HashSet<Resource>();
        for (Resource resource : contexts) {
            if (this.sail.unions.containsKey(resource)) {
                res.addAll((Collection)Arrays.asList(this.expandContext((Collection<? extends Resource>)this.sail.unions.get(resource))));
                continue;
            }
            res.add(resource);
        }
        return res.toArray(new Resource[res.size()]);
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.checkNotIn(contexts, this.sail.unions);
        Resource[] allcontexts = this.expandContext((Collection<? extends Resource>)Arrays.asList(contexts));
        super.removeStatements(subj, pred, obj, allcontexts);
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr query, BindingSet bs, boolean inf) throws SailException {
        ValueExpr postc = this.expandQuery((QueryModelNode)query, bs);
        if (postc != null) {
            Projection proj = (Projection)query;
            proj.setArg(this.addCondition(proj.getArg(), postc));
        }
        return super.evaluate(query, bs, inf);
    }

    private TupleExpr addCondition(TupleExpr expr, ValueExpr condition) {
        TupleExpr res = expr;
        if (expr instanceof StatementPattern) {
            res = new Selection(expr, condition);
        } else if (expr instanceof Selection) {
            Selection sel = (Selection)res;
            sel.setCondition((ValueExpr)new And(condition, sel.getCondition()));
        } else if (expr instanceof Join) {
            Join j = (Join)expr;
            j.setLeftArg(this.addCondition(j.getLeftArg(), condition));
            j.setRightArg(this.addCondition(j.getRightArg(), condition));
        } else {
            throw new RuntimeException("Support for " + expr.getClass() + " type arguments is not programmed yet. I suck. Sorry. ");
        }
        return res;
    }

    private ValueExpr expandQuery(QueryModelNode query, BindingSet bs) throws UnionSailException {
        Object res = null;
        if (query instanceof Projection) {
            Projection p = (Projection)query;
            ValueExpr sub = this.expandQuery((QueryModelNode)p.getArg(), bs);
            if (sub != null) {
                res = res == null ? sub : new And(sub, res);
            }
        } else if (query instanceof StatementPattern) {
            StatementPattern st = (StatementPattern)query;
            if (st.getScope() == StatementPattern.Scope.NAMED_CONTEXTS) {
                Var c = st.getContextVar();
                System.out.println(c);
                if (!c.hasValue()) {
                    throw new UnionSailException("This query is too complicated for the UnionSail, I cannot handle GRAPH variables.");
                }
                Resource[] all_c = this.expandContext((Resource)c.getValue());
                if (all_c.length > 1) {
                    Var cv = new Var("__unionVar_" + this.unionVarCount++);
                    st.setContextVar(cv);
                    res = new Compare((ValueExpr)cv, (ValueExpr)new Var("__unionConst" + this.unionConstCount++, (Value)all_c[0]));
                    int i = 1;
                    while (i < all_c.length) {
                        res = new Or(res, (ValueExpr)new Compare((ValueExpr)cv, (ValueExpr)new Var("__unionConst" + this.unionConstCount++, (Value)all_c[i])));
                        ++i;
                    }
                }
            }
        } else if (query instanceof Join) {
            Join j = (Join)query;
            ValueExpr left = this.expandQuery((QueryModelNode)j.getLeftArg(), bs);
            ValueExpr right = this.expandQuery((QueryModelNode)j.getRightArg(), bs);
            if (left != null) {
                res = right != null ? new Or(left, right) : left;
            } else if (right != null) {
                res = right;
            }
        } else {
            throw new RuntimeException("Support for " + query.getClass() + " type query elements is not programmed yet. I suck. Sorry. ");
        }
        return res;
    }
}

