/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import junit.framework.TestCase;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticdesktop.nepomuk.openrdf.UnionSail;

public abstract class UnionSailTest
extends TestCase {
    private URI A = new URIImpl("urn:a");
    private URI B = new URIImpl("urn:b");
    private URI C = new URIImpl("urn:c");
    private URI P = new URIImpl("urn:p");
    private URI O = new URIImpl("urn:o");
    private URI Q = new URIImpl("urn:q");
    private URI S = new URIImpl("urn:s");
    private URI T = new URIImpl("urn:t");
    private URI U = new URIImpl("urn:u");
    private Literal alabel = new LiteralImpl("a");
    private SailRepository repo;
    private MemoryStore base;
    private UnionSail unionsail;
    private SailRepositoryConnection c;

    protected void setUp() throws Exception {
        super.setUp();
        this.base = new MemoryStore();
        this.unionsail = this.createUnionSail(this.base);
        this.repo = new SailRepository((Sail)this.unionsail);
        this.repo.initialize();
        this.c = this.repo.getConnection();
    }

    protected abstract UnionSail createUnionSail(MemoryStore var1) throws SailException;

    protected void tearDown() throws Exception {
        super.tearDown();
        this.c.close();
        this.repo.shutDown();
    }

    public void testBasic() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        UnionSailTest.assertTrue((String)"Repo must contain statement", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        this.c.close();
    }

    public void testSingleUnion() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.unionsail.debug();
        RepositoryResult cid = this.c.getContextIDs();
        while (cid.hasNext()) {
            System.err.println(cid.next());
        }
        this.unionsail.createUnion(this.T, this.S);
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        this.c.close();
    }

    public void testSingleUnion2() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.c.add((Resource)this.A, this.P, (Value)this.C, new Resource[]{this.U});
        this.unionsail.createUnion(this.T, this.S);
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.C, false, new Resource[]{this.U}));
        UnionSailTest.assertFalse((String)"Repo must not contain statement in plain context.", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.C, false, new Resource[]{this.S}));
        UnionSailTest.assertFalse((String)"Repo must not contain statement in union.", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.C, false, new Resource[]{this.T}));
        this.c.close();
    }

    public void testChainUnion() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.unionsail.createUnion(this.T, this.S);
        this.unionsail.createUnion(this.U, this.T);
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in chained union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.U}));
        this.c.close();
    }

    public void testDelete() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.unionsail.createUnion(this.T, this.S);
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        this.c.remove((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        UnionSailTest.assertFalse((String)"Repo must not contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertFalse((String)"Repo must not contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        this.c.close();
    }

    public void testDeleteUnion() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.unionsail.createUnion(this.T, this.S);
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        try {
            this.c.remove((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.T});
            UnionSailTest.fail((String)"Should not be able to delete from union");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.c.close();
    }

    public void testSize() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.c.add((Resource)this.A, this.P, (Value)new URIImpl("urn:test:" + i), new Resource[]{this.S});
            ++i;
        }
        this.unionsail.createUnion(this.T, this.S);
        UnionSailTest.assertEquals((String)"Original context must have right size", (long)1000L, (long)this.c.size(new Resource[]{this.S}));
        UnionSailTest.assertEquals((String)"Union must have right size", (long)1000L, (long)this.c.size(new Resource[]{this.T}));
        this.c.close();
    }

    public void testTwoUnion() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.c.add((Resource)this.A, this.P, (Value)this.C, new Resource[]{this.U});
        this.unionsail.createUnion(this.T, this.S, this.U);
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.S}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in orig context. ", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.C, false, new Resource[]{this.U}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.B, false, new Resource[]{this.T}));
        UnionSailTest.assertTrue((String)"Repo must contain statement in union", (boolean)this.c.hasStatement((Resource)this.A, this.P, (Value)this.C, false, new Resource[]{this.T}));
        UnionSailTest.assertEquals((String)"Union must have right size", (long)2L, (long)this.c.size(new Resource[]{this.T}));
        this.c.close();
    }

    public void testTwoSize() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.c.add((Resource)this.A, this.P, (Value)new URIImpl("urn:test1:" + i), new Resource[]{this.S});
            ++i;
        }
        i = 0;
        while (i < 1000) {
            this.c.add((Resource)this.A, this.P, (Value)new URIImpl("urn:test2:" + i), new Resource[]{this.U});
            ++i;
        }
        this.unionsail.createUnion(this.T, this.S, this.U);
        UnionSailTest.assertEquals((String)"Original context must have right size", (long)1000L, (long)this.c.size(new Resource[]{this.S}));
        UnionSailTest.assertEquals((String)"Original context must have right size", (long)1000L, (long)this.c.size(new Resource[]{this.U}));
        UnionSailTest.assertEquals((String)"Union must have right size", (long)2000L, (long)this.c.size(new Resource[]{this.T}));
        this.c.close();
    }

    public void testQuery() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.unionsail.createUnion(this.T, this.S);
        String queryString = "SELECT ?x WHERE { GRAPH <" + this.S + "> { ?x ?y ?z } }";
        System.err.println(queryString);
        TupleQuery q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TupleQueryResult r = q.evaluate();
        UnionSailTest.assertTrue((boolean)r.hasNext());
        BindingSet b = (BindingSet)r.next();
        UnionSailTest.assertEquals((Object)this.A, (Object)b.getBinding("x").getValue());
        UnionSailTest.assertFalse((boolean)r.hasNext());
        r.close();
        queryString = "SELECT ?x WHERE { GRAPH <" + this.T + "> { ?x ?y ?z } }";
        System.err.println(queryString);
        q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        r = q.evaluate();
        UnionSailTest.assertTrue((boolean)r.hasNext());
        b = (BindingSet)r.next();
        UnionSailTest.assertEquals((Object)this.A, (Object)b.getBinding("x").getValue());
        UnionSailTest.assertFalse((boolean)r.hasNext());
        r.close();
        this.c.close();
    }

    public void testQuery2() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.U});
        this.unionsail.createUnion(this.T, this.S);
        String queryString = "SELECT ?x FROM NAMED <" + this.S + "> WHERE { GRAPH <" + this.S + "> { ?x ?y ?z } }";
        System.err.println(queryString);
        TupleQuery q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TupleQueryResult r = q.evaluate();
        UnionSailTest.assertFalse((boolean)r.hasNext());
        r.close();
        queryString = "SELECT ?x FROM <" + this.T + "> WHERE { GRAPH <" + this.T + "> { ?x ?y ?z } }";
        System.err.println(queryString);
        q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        r = q.evaluate();
        UnionSailTest.assertFalse((boolean)r.hasNext());
        r.close();
        this.c.close();
    }

    public void testQuery3() throws Exception {
        this.c.add((Resource)this.A, this.P, (Value)this.B, new Resource[]{this.S});
        this.c.add((Resource)this.B, this.Q, (Value)this.C, new Resource[]{this.T});
        this.unionsail.createUnion(this.U, this.S, this.T);
        String queryString = "SELECT ?x WHERE { GRAPH <" + this.S + "> { ?a ?p ?b . ?b ?q ?x. } }";
        System.err.println(queryString);
        TupleQuery q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TupleQueryResult r = q.evaluate();
        if (r.hasNext()) {
            System.err.println(r.getBindingNames());
            while (r.hasNext()) {
                System.err.println(r.next());
            }
            UnionSailTest.fail((String)"Query shouldn't have any matches.");
        }
        r.close();
        queryString = "SELECT ?x WHERE { GRAPH <" + this.T + "> { ?a ?p ?b . ?b ?q ?x. } }";
        System.err.println(queryString);
        q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        r = q.evaluate();
        UnionSailTest.assertFalse((boolean)r.hasNext());
        r.close();
        queryString = "SELECT ?x WHERE { GRAPH <" + this.U + "> { ?a ?p ?b . ?b ?q ?x. } }";
        System.err.println(queryString);
        q = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        r = q.evaluate();
        UnionSailTest.assertTrue((boolean)r.hasNext());
        BindingSet b = (BindingSet)r.next();
        UnionSailTest.assertEquals((Object)this.C, (Object)b.getBinding("x").getValue());
        UnionSailTest.assertFalse((boolean)r.hasNext());
        r.close();
        this.c.close();
    }

    public void testSpeed() throws Exception {
        String data = "@prefix foaf: <http://xmlns.com/foaf/0.1/>. \n<urn:dirk> foaf:name \"dirk\" . ";
        String[][] queries = new String[][]{{"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { ?x foaf:name \"dirk\" . } ", "whole graph", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { graph <urn:union> { ?x foaf:name \"dirk\" } . } ", "simple unionall", "1"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { graph <urn:unionX> { ?x foaf:name \"dirk\" } . } ", "simple unionnone", "1"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . } ", "graph var", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union> ) } ", "graph filter all", "1"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union1> ) } ", "graph filter half", "1"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union3> ) } ", "graph filter nested", "1"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union> || ?g = <urn:unionX> ) } ", "graph filter or none", "1"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union1> || ?g = <urn:union2> ) } ", "graph filter both halves", "1"}};
        Vector<URIImpl> all = new Vector<URIImpl>();
        Vector<URIImpl> half1 = new Vector<URIImpl>();
        Vector<URIImpl> half2 = new Vector<URIImpl>();
        int i = 1;
        while (i <= 2000) {
            if (i % 100 == 0) {
                System.err.print("Setting up... " + i + "   \r");
            }
            StringBuilder sb = new StringBuilder(data);
            int j = 1;
            while (j < i) {
                sb.append("\n<urn:dirk" + j + "> foaf:name \"dirk" + j + "\" .");
                j += 10;
            }
            URIImpl con = new URIImpl("urn:context" + i);
            this.c.add((Reader)new StringReader(sb.toString()), "http://example.org/", RDFFormat.N3, new Resource[]{con});
            all.add(con);
            if (i < 1000) {
                half1.add(con);
            } else {
                half2.add(con);
            }
            ++i;
        }
        System.err.println();
        this.c.commit();
        URI[] contexts = all.toArray(new URI[all.size()]);
        this.unionsail.createUnion((URI)new URIImpl("urn:union"), contexts);
        this.unionsail.createUnion((URI)new URIImpl("urn:union1"), half1.toArray(new URI[half1.size()]));
        this.unionsail.createUnion((URI)new URIImpl("urn:union2"), half2.toArray(new URI[half2.size()]));
        this.unionsail.createUnion((URI)new URIImpl("urn:union3"), new URI[]{new URIImpl("urn:union1"), new URIImpl("urn:union2")});
        int iQuery = 0;
        while (iQuery < queries.length) {
            TupleQuery tq = this.c.prepareTupleQuery(QueryLanguage.SPARQL, queries[iQuery][0]);
            System.err.println("Query " + (iQuery + 1) + ": " + queries[iQuery][1]);
            long ctm = System.currentTimeMillis();
            TupleQueryResult qr = tq.evaluate();
            System.err.println("Elapsed: " + (System.currentTimeMillis() - ctm) + "ms");
            int res = 0;
            while (qr.hasNext()) {
                String s = ((BindingSet)qr.next()).toString();
                ++res;
            }
            System.err.println(String.valueOf(res) + " results, " + queries[iQuery][2] + " expected");
            qr.close();
            ++iQuery;
        }
    }
}

