/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.Reasoning;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.util.RDFTool;
import org.ontoware.rdf2go.vocabulary.OWL;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;

public class VocabularyWriter {
    String inputRdf = null;
    String outputDirName = null;
    String outputFileName = null;
    String ns = null;
    String packageName = null;
    Model model = null;
    PrintStream outP;
    File inputRdfFile;
    File outputDirFile;
    File outputFile;
    boolean namespacestrict = false;
    HashMap<String, String> uriToLocalName = new HashMap();

    public void go(String[] args) throws Exception {
        this.getOpt(args);
        this.loadOnt();
        this.writeVocab();
    }

    private void loadOnt() throws Exception {
        Syntax syntax = RDFTool.guessSyntax(this.inputRdfFile.toString());
        this.model = RDF2Go.getModelFactory().createModel(Reasoning.none);
        this.model.open();
        System.out.println("reading from " + this.inputRdfFile.getAbsolutePath() + " in format " + syntax);
        BufferedReader reader = new BufferedReader(new FileReader(this.inputRdfFile));
        this.model.readFrom((Reader)reader, syntax);
        ((Reader)reader).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVocab() throws Exception {
        this.outP = new PrintStream(this.outputFile);
        try {
            this.outP.println("package " + this.packageName + ";\n");
            this.outP.println("import org.ontoware.rdf2go.model.node.URI;");
            this.outP.println("import org.ontoware.rdf2go.model.node.impl.URIImpl;\n");
            this.outP.println("/**");
            this.outP.println(" * Vocabulary File. Created by " + VocabularyWriter.class.getName() + " on " + new Date());
            this.outP.println(" * input file: " + this.inputRdf);
            this.outP.println(" * namespace: " + this.ns);
            this.outP.println(" */");
            this.outP.println("public interface " + this.outputFileName + " {");
            this.outP.println("\tpublic static final URI NS_" + this.outputFileName + " = new URIImpl(\"" + this.ns + "\",false);\n");
            this.generateElement(RDFS.Class, false);
            this.generateElement(OWL.Class, false);
            this.generateElement(RDF.Property, true);
            this.generateElement(OWL.DatatypeProperty, true);
            this.generateElement(OWL.ObjectProperty, true);
            this.outP.println("}");
        }
        finally {
            this.outP.close();
        }
        System.out.println("successfully wrote file to " + this.outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateElement(URI type, boolean isProperty) throws Exception {
        ClosableIterator queryC = this.model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDF.type, (NodeOrVariable)type);
        try {
            while (queryC.hasNext()) {
                Statement answer = (Statement)queryC.next();
                Resource rx = answer.getSubject();
                if (!(rx instanceof URI)) continue;
                URI vx = (URI)rx;
                String uri = vx.toString();
                boolean valid = this.model.isValidURI(uri);
                if (!valid) {
                    this.outP.println("    /* cannot export " + uri + ", not a valid URI */");
                    continue;
                }
                String localName = this.getLocalName(vx);
                String javalocalName = this.asLegalJavaID(localName, !isProperty);
                if (this.uriToLocalName.containsKey(uri)) continue;
                this.uriToLocalName.put(uri, javalocalName);
                if (this.namespacestrict && !uri.startsWith(this.ns)) continue;
                this.outP.println("    /**");
                this.printCommentAndLabel(vx);
                this.outP.println("     */");
                this.outP.println("    public static final URI " + javalocalName + " = new URIImpl(\"" + uri + "\", false);\n");
            }
        }
        finally {
            queryC.close();
        }
    }

    private String getLocalName(URI vx) {
        String fullUri = vx.toString();
        int splitIdx = fullUri.indexOf(35);
        if (splitIdx < 0) {
            splitIdx = fullUri.lastIndexOf(47);
        }
        if (splitIdx < 0) {
            splitIdx = fullUri.lastIndexOf(58);
        }
        if (splitIdx < 0) {
            throw new RuntimeException("Not a legal (absolute) URI: " + fullUri);
        }
        return fullUri.substring(splitIdx + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCommentAndLabel(URI uri) throws Exception {
        String l;
        Node vl;
        Statement answer;
        ClosableIterator queryC = this.model.findStatements((ResourceOrVariable)uri, (UriOrVariable)RDFS.label, (NodeOrVariable)Variable.ANY);
        try {
            StringBuffer lBuf = new StringBuffer();
            while (queryC.hasNext()) {
                answer = (Statement)queryC.next();
                vl = answer.getObject();
                lBuf.append(vl.toString().concat(" "));
            }
            String l2 = lBuf.toString();
            if (l2.length() > 0) {
                this.outP.println("     * Label: " + l2);
            }
        }
        finally {
            queryC.close();
        }
        queryC = this.model.findStatements((ResourceOrVariable)uri, (UriOrVariable)RDFS.comment, (NodeOrVariable)Variable.ANY);
        try {
            l = "";
            while (queryC.hasNext()) {
                answer = (Statement)queryC.next();
                vl = answer.getObject();
                l = l + vl.toString() + " ";
            }
            if (l.length() > 0) {
                this.outP.println("     * Comment: " + l);
            }
        }
        finally {
            queryC.close();
        }
        queryC = this.model.findStatements((ResourceOrVariable)uri, (UriOrVariable)RDFS.domain, (NodeOrVariable)Variable.ANY);
        try {
            l = "";
            while (queryC.hasNext()) {
                answer = (Statement)queryC.next();
                vl = answer.getObject();
                l = l + vl.toString() + " ";
            }
            if (l.length() > 0) {
                this.outP.println("     * Comment: " + l);
            }
        }
        finally {
            queryC.close();
        }
        queryC = this.model.findStatements((ResourceOrVariable)uri, (UriOrVariable)RDFS.range, (NodeOrVariable)Variable.ANY);
        try {
            l = "";
            while (queryC.hasNext()) {
                answer = (Statement)queryC.next();
                vl = answer.getObject();
                l = l + vl.toString() + " ";
            }
            if (l.length() > 0) {
                this.outP.println("     * Range: " + l);
            }
        }
        finally {
            queryC.close();
        }
    }

    public void getOpt(String[] args) throws Exception {
        if (args.length == 0) {
            this.help();
            throw new Exception("no arguments given");
        }
        for (int i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("-i")) {
                this.inputRdf = args[++i];
                continue;
            }
            if (args[i].equals("-o")) {
                this.outputDirName = args[++i];
                continue;
            }
            if (args[i].equals("-a")) {
                this.ns = args[++i];
                continue;
            }
            if (args[i].equals("-n")) {
                this.outputFileName = args[++i];
                continue;
            }
            if (args[i].equals("--package")) {
                this.packageName = args[++i];
                continue;
            }
            if (args[i].equals("-namespacestrict")) {
                String s;
                if ("false".equals(s = args[++i])) {
                    this.namespacestrict = false;
                    continue;
                }
                if ("true".equals(s)) {
                    this.namespacestrict = true;
                    continue;
                }
                throw new Exception("namespacestrict only allows 'true' or 'false', not '" + s + "'");
            }
            throw new Exception("unknow argument " + args[i]);
        }
        if (this.inputRdf == null) {
            VocabularyWriter.usage("no input file given");
        }
        if (this.outputDirName == null) {
            VocabularyWriter.usage("no output dir given");
        }
        if (this.ns == null) {
            VocabularyWriter.usage("no namespace given");
        }
        if (this.outputFileName == null) {
            VocabularyWriter.usage("no output classname given");
        }
        if (this.packageName == null) {
            VocabularyWriter.usage("no package name given");
        }
        this.inputRdfFile = new File(this.inputRdf);
        this.outputDirFile = new File(this.outputDirName);
        this.outputFile = new File(this.outputDirFile, this.outputFileName + ".java");
    }

    private void help() {
        System.err.println("Syntax: java VocabularyWriter -i inputfile -o outputdir -a namespace -n classname --package package ");
    }

    public static void main(String[] args) throws Exception {
        new VocabularyWriter().go(args);
    }

    protected String asLegalJavaID(String s, boolean cap) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        try {
            while (!Character.isJavaIdentifierStart(s.charAt(i))) {
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println("Could not identify legal Java identifier start character in '" + s + "', replacing with __");
            return "__";
        }
        buf.append(cap ? Character.toUpperCase(s.charAt(i)) : s.charAt(i));
        ++i;
        while (i < s.length()) {
            char c = s.charAt(i);
            buf.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++i;
        }
        String result = buf.toString();
        if (result.equals("class") || result.equals("abstract")) {
            result = result + "_";
        }
        return result;
    }

    private static void usage(String string) throws Exception {
        throw new Exception(string);
    }
}

