/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.util.transform;

import java.util.Map;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.util.transform.SearchRemoveAddRule;
import org.ontoware.rdf2go.util.transform.TransformerRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URISearchReplaceRule
implements TransformerRule {
    private URI search;
    private URI replace;

    public URISearchReplaceRule(URI search, URI replace) {
        this.search = search;
        this.replace = replace;
    }

    @Override
    public void applyRule(Model model, Map<String, URI> namespaceMap) {
        URISearchReplaceRule.searchAndReplace(model, namespaceMap, this.search, this.replace);
    }

    public static void searchAndReplace(Model model, Map<String, URI> namespaceMap, URI search, URI replace) {
        SearchRemoveAddRule.searchAndReplace(model, namespaceMap, search.toSPARQL() + " ?p ?o", search.toSPARQL() + " ?p ?o", replace.toSPARQL() + " ?p ?o");
        SearchRemoveAddRule.searchAndReplace(model, namespaceMap, "?s " + search.toSPARQL() + " ?o", "?s " + search.toSPARQL() + " ?o", "?s " + replace.toSPARQL() + " ?o");
        SearchRemoveAddRule.searchAndReplace(model, namespaceMap, "?s ?p " + search.toSPARQL(), "?s ?p " + search.toSPARQL(), "?s ?p " + replace.toSPARQL());
    }
}

