/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Controller;
import org.simpleframework.http.core.Timer;
import org.simpleframework.http.message.Entity;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class ResponseObserver
implements BodyObserver {
    private AtomicBoolean committed;
    private AtomicBoolean closed;
    private AtomicBoolean error;
    private Controller controller;
    private Channel channel;
    private Trace trace;
    private Timer timer = new Timer(TimeUnit.MILLISECONDS);

    public ResponseObserver(Controller controller, Entity entity) {
        this.committed = new AtomicBoolean();
        this.closed = new AtomicBoolean();
        this.error = new AtomicBoolean();
        this.channel = entity.getChannel();
        this.trace = this.channel.getTrace();
        this.controller = controller;
    }

    public void close(ByteWriter writer) {
        try {
            if (!this.isClosed()) {
                this.closed.set(true);
                this.timer.set();
                this.trace.trace((Object)ContainerEvent.RESPONSE_FINISHED);
                writer.close();
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, (Object)cause);
            this.fail(writer);
        }
    }

    public void error(ByteWriter writer) {
        try {
            if (!this.isClosed()) {
                this.error.set(true);
                this.timer.set();
                this.trace.trace((Object)ContainerEvent.RESPONSE_FINISHED);
                writer.close();
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, (Object)cause);
            this.fail(writer);
        }
    }

    public void ready(ByteWriter writer) {
        try {
            if (!this.isClosed()) {
                this.closed.set(true);
                writer.flush();
                this.timer.set();
                this.trace.trace((Object)ContainerEvent.RESPONSE_FINISHED);
                this.controller.start(this.channel);
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, (Object)cause);
            this.fail(writer);
        }
    }

    private void fail(ByteWriter writer) {
        try {
            writer.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, (Object)cause);
        }
    }

    public void commit(ByteWriter writer) {
        this.committed.set(true);
    }

    public boolean isCommitted() {
        return this.committed.get();
    }

    public boolean isClosed() {
        return this.closed.get() || this.error.get();
    }

    public boolean isError() {
        return this.error.get();
    }

    public long getTime() {
        return this.timer.get();
    }
}

