/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.http.message.ByteConsumer;
import org.simpleframework.http.message.ConsumerFactory;
import org.simpleframework.http.message.ContinueDispatcher;
import org.simpleframework.http.message.Header;
import org.simpleframework.http.message.RequestConsumer;
import org.simpleframework.transport.ByteCursor;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

public class EntityConsumer
implements ByteConsumer {
    protected ContinueDispatcher dispatcher;
    protected ConsumerFactory factory;
    protected RequestConsumer header = new RequestConsumer();
    protected BodyConsumer body;
    protected Trace trace;

    public EntityConsumer(Allocator allocator, Channel channel) {
        this.dispatcher = new ContinueDispatcher(channel);
        this.factory = new ConsumerFactory(allocator, this.header);
        this.trace = channel.getTrace();
    }

    public Body getBody() {
        return this.body.getBody();
    }

    public Header getHeader() {
        return this.header;
    }

    public void consume(ByteCursor cursor) throws IOException {
        CharSequence sequence;
        while (cursor.isReady()) {
            if (this.header.isFinished()) {
                if (this.body == null) {
                    sequence = this.header.getHeader();
                    this.trace.trace((Object)ContainerEvent.HEADER_FINISHED, (Object)sequence);
                    this.body = this.factory.getInstance();
                }
                this.trace.trace((Object)ContainerEvent.READ_BODY);
                this.body.consume(cursor);
                if (!this.body.isFinished()) continue;
                this.trace.trace((Object)ContainerEvent.BODY_FINISHED);
                break;
            }
            this.trace.trace((Object)ContainerEvent.READ_HEADER);
            this.header.consume(cursor);
        }
        if (this.header.isFinished() && this.body == null) {
            sequence = this.header.getHeader();
            this.trace.trace((Object)ContainerEvent.HEADER_FINISHED, (Object)sequence);
            this.dispatcher.execute(this.header);
            this.body = this.factory.getInstance();
        }
    }

    public boolean isFinished() {
        if (this.header.isFinished()) {
            if (this.body == null) {
                CharSequence sequence = this.header.getHeader();
                this.trace.trace((Object)ContainerEvent.HEADER_FINISHED, (Object)sequence);
                this.body = this.factory.getInstance();
            }
            return this.body.isFinished();
        }
        return false;
    }

    public boolean isHeaderFinished() {
        return this.header.isFinished();
    }
}

