/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.util.concurrent.atomic.AtomicLong;
import org.simpleframework.common.thread.Scheduler;
import org.simpleframework.http.Request;
import org.simpleframework.http.socket.CloseCode;
import org.simpleframework.http.socket.DataFrame;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.service.FrameConnection;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.http.socket.service.StatusResultListener;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class StatusChecker
implements Runnable {
    private final StatusResultListener listener = new StatusResultListener(this);
    private final FrameConnection connection;
    private final Scheduler scheduler;
    private final AtomicLong counter;
    private final Channel channel;
    private final Reason normal;
    private final Reason error = new Reason(CloseCode.INTERNAL_SERVER_ERROR);
    private final Trace trace;
    private final Frame frame;
    private final long frequency;

    public StatusChecker(FrameConnection connection, Request request, Scheduler scheduler, long frequency) {
        this.normal = new Reason(CloseCode.NORMAL_CLOSURE);
        this.frame = new DataFrame(FrameType.PING);
        this.counter = new AtomicLong();
        this.channel = request.getChannel();
        this.trace = this.channel.getTrace();
        this.connection = connection;
        this.scheduler = scheduler;
        this.frequency = frequency;
    }

    public void start() {
        try {
            this.connection.register(this.listener);
            this.trace.trace((Object)ServiceEvent.WRITE_PING);
            this.connection.send(this.frame);
            this.counter.getAndIncrement();
            this.scheduler.execute((Runnable)this, this.frequency);
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }

    public void run() {
        long count = this.counter.get();
        try {
            if (count < 3L) {
                this.trace.trace((Object)ServiceEvent.WRITE_PING);
                this.connection.send(this.frame);
                this.counter.getAndIncrement();
                this.scheduler.execute((Runnable)this, this.frequency);
            } else {
                this.trace.trace((Object)ServiceEvent.PING_EXPIRED);
                this.connection.close(this.normal);
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }

    public void refresh() {
        try {
            this.trace.trace((Object)ServiceEvent.PONG_RECEIVED);
            this.counter.set(0L);
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }

    public void failure() {
        try {
            this.connection.close(this.error);
            this.channel.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }

    public void close() {
        try {
            this.connection.close(this.normal);
            this.channel.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }
}

