/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.jdk.platform.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.helpers.Reporter;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventBuilder;

class SLF4JPlatformLogger
implements System.Logger {
    private static final String PRESUMED_CALLER_BOUNDARY = System.Logger.class.getName();
    private final Logger slf4jLogger;

    public SLF4JPlatformLogger(Logger logger) {
        this.slf4jLogger = Objects.requireNonNull(logger);
    }

    @Override
    public String getName() {
        return this.slf4jLogger.getName();
    }

    @Override
    public boolean isLoggable(System.Logger.Level jplLevel) {
        if (jplLevel == System.Logger.Level.ALL) {
            return true;
        }
        if (jplLevel == System.Logger.Level.OFF) {
            return true;
        }
        Level slf4jLevel = this.jplLevelToSLF4JLevel(jplLevel);
        return this.slf4jLogger.isEnabledForLevel(slf4jLevel);
    }

    private Level jplLevelToSLF4JLevel(System.Logger.Level jplLevel) {
        switch (jplLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        this.reportUnknownLevel(jplLevel);
        return null;
    }

    @Override
    public void log(System.Logger.Level jplLevel, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(jplLevel, bundle, msg, thrown, (Object[])null);
    }

    @Override
    public void log(System.Logger.Level jplLevel, ResourceBundle bundle, String format, Object ... params) {
        this.log(jplLevel, bundle, format, null, params);
    }

    private void log(System.Logger.Level jplLevel, ResourceBundle bundle, String msg, Throwable thrown, Object ... params) {
        if (jplLevel == System.Logger.Level.OFF) {
            return;
        }
        if (jplLevel == System.Logger.Level.ALL) {
            this.performLog(Level.TRACE, bundle, msg, thrown, params);
            return;
        }
        Level slf4jLevel = this.jplLevelToSLF4JLevel(jplLevel);
        boolean isEnabled = this.slf4jLogger.isEnabledForLevel(slf4jLevel);
        if (isEnabled) {
            this.performLog(slf4jLevel, bundle, msg, thrown, params);
        }
    }

    private void performLog(Level slf4jLevel, ResourceBundle bundle, String msg, Throwable thrown, Object ... params) {
        String message = SLF4JPlatformLogger.getResourceStringOrMessage(bundle, msg);
        LoggingEventBuilder leb = this.slf4jLogger.makeLoggingEventBuilder(slf4jLevel);
        if (thrown != null) {
            leb = leb.setCause(thrown);
        }
        if (params != null && params.length > 0) {
            for (Object p : params) {
                leb = leb.addArgument(p);
            }
            message = MessageFormat.format(message, params);
        }
        if (leb instanceof CallerBoundaryAware) {
            CallerBoundaryAware cba = (CallerBoundaryAware)leb;
            cba.setCallerBoundary(PRESUMED_CALLER_BOUNDARY);
        }
        leb.log(message);
    }

    private void reportUnknownLevel(System.Logger.Level jplLevel) {
        String message = "Unknown log level [" + String.valueOf((Object)jplLevel) + "]";
        IllegalArgumentException iae = new IllegalArgumentException(message);
        Reporter.error((String)"Unsupported log level", (Throwable)iae);
    }

    private static String getResourceStringOrMessage(ResourceBundle bundle, String msg) {
        if (bundle == null || msg == null) {
            return msg;
        }
        try {
            return bundle.getString(msg);
        }
        catch (MissingResourceException ex) {
            return msg;
        }
        catch (ClassCastException ex) {
            return bundle.getObject(msg).toString();
        }
    }
}

