/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.AnalysisException;

public class JavaAstScanner {
    private static final Logger LOG = Loggers.get(JavaAstScanner.class);
    private final ActionParser<Tree> parser;
    private VisitorsBridge visitor;

    public JavaAstScanner(ActionParser<Tree> parser) {
        this.parser = parser;
    }

    public JavaAstScanner(JavaAstScanner astScanner) {
        this.parser = astScanner.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<File> files) {
        ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList(files));
        boolean successfullyCompleted = false;
        try {
            for (File file : files) {
                this.simpleScan(file);
                progressReport.nextFile();
            }
            successfullyCompleted = true;
        }
        finally {
            if (successfullyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    private void simpleScan(File file) {
        this.visitor.setCurrentFile(file);
        try {
            Tree ast = (Tree)this.parser.parse(file);
            this.visitor.visitFile(ast);
        }
        catch (RecognitionException e) {
            JavaAstScanner.checkInterrrupted((Exception)((Object)e));
            LOG.error("Unable to parse source file : " + file.getAbsolutePath());
            LOG.error(e.getMessage());
            this.parseErrorWalkAndVisit(e, file);
        }
        catch (Exception e) {
            JavaAstScanner.checkInterrrupted(e);
            throw new AnalysisException(JavaAstScanner.getAnalyisExceptionMessage(file), (Throwable)e);
        }
        catch (StackOverflowError error) {
            LOG.error("A stack overflow error occured while analyzing file: " + file.getAbsolutePath());
            throw error;
        }
    }

    private static void checkInterrrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", (Throwable)e);
        }
    }

    private void parseErrorWalkAndVisit(RecognitionException e, File file) {
        try {
            this.visitor.visitFile(null);
            this.visitor.processRecognitionException(e);
        }
        catch (Exception e2) {
            throw new AnalysisException(JavaAstScanner.getAnalyisExceptionMessage(file), (Throwable)e2);
        }
    }

    private static String getAnalyisExceptionMessage(File file) {
        return "SonarQube is unable to analyze file : '" + file.getAbsolutePath() + "'";
    }

    public void setVisitorBridge(VisitorsBridge visitor) {
        this.visitor = visitor;
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(File file, VisitorsBridge visitorsBridge) {
        JavaAstScanner.scanSingleFileForTests(file, visitorsBridge, new JavaConfiguration(Charset.forName("UTF-8")));
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(File file, VisitorsBridge visitorsBridge, JavaConfiguration conf) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        JavaAstScanner scanner = JavaAstScanner.create(conf, visitorsBridge);
        scanner.scan(Collections.singleton(file));
    }

    private static JavaAstScanner create(JavaConfiguration conf, @Nullable VisitorsBridge visitorsBridge) {
        JavaAstScanner astScanner = new JavaAstScanner(JavaParser.createParser(conf.getCharset()));
        if (visitorsBridge != null) {
            visitorsBridge.setCharset(conf.getCharset());
            visitorsBridge.setJavaVersion(conf.javaVersion());
            astScanner.setVisitorBridge(visitorsBridge);
        }
        return astScanner;
    }
}

