/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class WhileStatementTreeImpl
extends JavaTree
implements WhileStatementTree {
    private final ExpressionTree condition;
    private final StatementTree statement;
    private final InternalSyntaxToken whileKeyword;
    private final InternalSyntaxToken openParenToken;
    private final InternalSyntaxToken closeParenToken;

    public WhileStatementTreeImpl(InternalSyntaxToken whileKeyword, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree statement) {
        super(Tree.Kind.WHILE_STATEMENT);
        this.whileKeyword = whileKeyword;
        this.openParenToken = openParenToken;
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.closeParenToken = closeParenToken;
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.WHILE_STATEMENT;
    }

    @Override
    public SyntaxToken whileKeyword() {
        return this.whileKeyword;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Lists.newArrayList((Object[])new Tree[]{this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement});
    }
}

