/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import javax.annotation.Nullable;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class JavaType
implements Type {
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BOOLEAN = 8;
    public static final int VOID = 9;
    public static final int CLASS = 10;
    public static final int ARRAY = 11;
    public static final int METHOD = 12;
    public static final int BOT = 13;
    public static final int UNKNOWN = 14;
    public static final int TYPEVAR = 15;
    public static final int WILDCARD = 16;
    public static final int DEFERRED = 17;
    public static final int PARAMETERIZED = 18;
    int tag;
    JavaType primitiveType = null;
    JavaType primitiveWrapperType = null;
    JavaSymbol.TypeJavaSymbol symbol;

    public JavaType(int tag, JavaSymbol.TypeJavaSymbol symbol) {
        this.tag = tag;
        this.symbol = symbol;
    }

    public boolean isTagged(int tag) {
        return tag == this.tag;
    }

    @Override
    public boolean isNumerical() {
        return this.tag <= 7;
    }

    public JavaSymbol.TypeJavaSymbol getSymbol() {
        this.symbol.complete();
        return this.symbol;
    }

    @Override
    public boolean is(String fullyQualifiedName) {
        if (this.tag < 10) {
            return fullyQualifiedName.equals(this.symbol.name);
        }
        if (this.isTagged(11)) {
            return fullyQualifiedName.endsWith("[]") && ((ArrayJavaType)this).elementType.is(fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2));
        }
        if (this.isTagged(15)) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(String fullyQualifiedName) {
        if (this.isTagged(11)) {
            return "java.lang.Object".equals(fullyQualifiedName) || fullyQualifiedName.endsWith("[]") && ((ArrayJavaType)this).elementType.isSubtypeOf(fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2));
        }
        if (this.isTagged(15)) {
            return this.erasure().isSubtypeOf(fullyQualifiedName);
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        JavaType supType = (JavaType)superType;
        if (this.isTagged(11)) {
            if (supType.isTagged(11)) {
                return ((Type.ArrayType)((Object)this)).elementType().isSubtypeOf(((Type.ArrayType)((Object)supType)).elementType());
            }
            if (supType.isTagged(16)) {
                return ((WildCardType)superType).isSubtypeOfBound(this);
            }
            return "java.lang.Object".equals(supType.fullyQualifiedName());
        }
        return false;
    }

    @Override
    public JavaType erasure() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return this.tag <= 8;
    }

    @Override
    public boolean isPrimitive(Type.Primitives primitive) {
        return this.tag == primitive.ordinal() + 1;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    public boolean isPrimitiveWrapper() {
        if (!this.isTagged(10)) {
            return false;
        }
        return this.is("java.lang.Byte") || this.is("java.lang.Character") || this.is("java.lang.Short") || this.is("java.lang.Integer") || this.is("java.lang.Long") || this.is("java.lang.Float") || this.is("java.lang.Double") || this.is("java.lang.Boolean");
    }

    public String toString() {
        return this.symbol == null ? "" : this.symbol.toString();
    }

    @Nullable
    public JavaType primitiveType() {
        return this.primitiveType;
    }

    @Nullable
    public JavaType primitiveWrapperType() {
        return this.primitiveWrapperType;
    }

    @Override
    public boolean isArray() {
        return this.isTagged(11);
    }

    public boolean isParameterized() {
        return this.isTagged(18);
    }

    @Override
    public boolean isClass() {
        return this.isTagged(10) || this.isTagged(18);
    }

    @Override
    public boolean isVoid() {
        return this.isTagged(9);
    }

    @Override
    public String fullyQualifiedName() {
        return this.symbol.getFullyQualifiedName();
    }

    @Override
    public String name() {
        return this.symbol.name;
    }

    @Override
    public Symbol.TypeSymbol symbol() {
        return this.getSymbol();
    }
}

