/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeSubstitutionSolver;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class LeastUpperBound {
    private final Symbols symbols;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final TypeSubstitutionSolver typeSubstitutionSolver;
    private final Set<Set<Type>> lubCache = new HashSet<Set<Type>>();

    public LeastUpperBound(TypeSubstitutionSolver typeSubstitutionSolver, ParametrizedTypeCache parametrizedTypeCache, Symbols symbols) {
        this.symbols = symbols;
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.typeSubstitutionSolver = typeSubstitutionSolver;
    }

    public Type leastUpperBound(Set<Type> types) {
        Type lub = this.cachedLeastUpperBound(types);
        this.lubCache.clear();
        return lub;
    }

    private Type cachedLeastUpperBound(Set<Type> types) {
        HashSet<Type> searchedTypes;
        Type erasedBest;
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0);
        Iterator<Type> iterator = types.iterator();
        Type first = iterator.next();
        if (types.size() == 1) {
            return first;
        }
        List<Set<Type>> supertypes = this.supertypes(types);
        List<Set<Type>> erasedSupertypes = LeastUpperBound.erased(supertypes);
        List<Type> erasedCandidates = LeastUpperBound.intersection(erasedSupertypes);
        List<Type> minimalErasedCandidates = LeastUpperBound.minimalCandidates(erasedCandidates);
        if (minimalErasedCandidates.isEmpty()) {
            return Symbols.unknownType;
        }
        Multimap<Type, Type> relevantParameterizations = LeastUpperBound.relevantParameterizations(minimalErasedCandidates, supertypes);
        Collection erasedTypeParameterizations = relevantParameterizations.get((Object)(erasedBest = LeastUpperBound.best(minimalErasedCandidates)));
        if (erasedTypeParameterizations != null && !erasedTypeParameterizations.contains(erasedBest) && !this.lubCache.contains(searchedTypes = new HashSet<Type>(types))) {
            this.lubCache.add(searchedTypes);
            return this.leastContainingParameterization(new ArrayList<Type>(erasedTypeParameterizations));
        }
        return erasedBest;
    }

    private List<Set<Type>> supertypes(Collection<Type> types) {
        return types.stream().map(type -> this.supertypes((JavaType)type).stream().collect(Collectors.toCollection(LinkedHashSet::new))).collect(Collectors.toList());
    }

    @VisibleForTesting
    Set<Type> supertypes(JavaType type) {
        ArrayList<Type> result = new ArrayList<Type>();
        result.add(type);
        Symbol.TypeSymbol symbol = type.symbol();
        TypeSubstitution substitution = LeastUpperBound.getTypeSubstitution(type);
        result.addAll(this.interfacesWithSubstitution(symbol, substitution));
        Type superClass = symbol.superClass();
        while (superClass != null) {
            JavaType substitutedSuperClass = this.applySubstitution(superClass, substitution);
            result.add(substitutedSuperClass);
            substitution = LeastUpperBound.getTypeSubstitution(substitutedSuperClass);
            JavaSymbol.TypeJavaSymbol superClassSymbol = substitutedSuperClass.getSymbol();
            result.addAll(this.interfacesWithSubstitution(superClassSymbol, substitution));
            superClass = superClassSymbol.superClass();
        }
        return new LinkedHashSet<Type>(result);
    }

    private Set<Type> interfacesWithSubstitution(Symbol.TypeSymbol symbol, TypeSubstitution substitution) {
        return symbol.interfaces().stream().flatMap(interfaceType -> this.supertypes(this.applySubstitution((Type)interfaceType, substitution)).stream()).collect(Collectors.toSet());
    }

    private static TypeSubstitution getTypeSubstitution(JavaType type) {
        return type.isTagged(18) ? ((ParametrizedTypeJavaType)type).typeSubstitution : new TypeSubstitution();
    }

    private JavaType applySubstitution(Type type, TypeSubstitution substitution) {
        return this.typeSubstitutionSolver.applySubstitution((JavaType)type, substitution);
    }

    private static List<Set<Type>> erased(List<Set<Type>> typeSets) {
        return typeSets.stream().map(set -> set.stream().map(type -> type.erasure()).collect(Collectors.toCollection(LinkedHashSet::new))).collect(Collectors.toList());
    }

    private static List<Type> intersection(List<Set<Type>> supertypes) {
        return new ArrayList<Type>((Collection)supertypes.stream().reduce(LeastUpperBound.union(supertypes), Sets::intersection));
    }

    private static Set<Type> union(List<Set<Type>> supertypes) {
        return supertypes.stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static List<Type> minimalCandidates(List<Type> erasedCandidates) {
        ArrayList<Type> results = new ArrayList<Type>();
        for (Type v : erasedCandidates) {
            if (!erasedCandidates.stream().noneMatch(w -> !w.equals(v) && w.isSubtypeOf(v))) continue;
            results.add(v);
        }
        return results;
    }

    private static Multimap<Type, Type> relevantParameterizations(List<Type> minimalErasedCandidates, List<Set<Type>> supertypes) {
        SetMultimap result = Multimaps.newSetMultimap(new HashMap(), LinkedHashSet::new);
        for (Set<Type> supertypesSet : supertypes) {
            for (Type supertype : supertypesSet) {
                Type erasedSupertype = supertype.erasure();
                if (!minimalErasedCandidates.contains(erasedSupertype)) continue;
                result.put((Object)erasedSupertype, (Object)supertype);
            }
        }
        return result;
    }

    @VisibleForTesting
    static Type best(List<Type> minimalCandidates) {
        Collections.sort(minimalCandidates, (t1, t2) -> {
            Symbol.TypeSymbol t1Symbol = t1.symbol();
            Symbol.TypeSymbol t2Symbol = t2.symbol();
            if (t1Symbol.isInterface() && t2Symbol.isInterface()) {
                return t1.name().compareTo(t2.name());
            }
            if (t1Symbol.isInterface()) {
                return 1;
            }
            if (t2Symbol.isInterface()) {
                return -1;
            }
            return t1.name().compareTo(t2.name());
        });
        return minimalCandidates.get(0);
    }

    private Type leastContainingParameterization(List<Type> types) {
        if (types.size() == 1) {
            return types.get(0);
        }
        JavaType type1 = (JavaType)types.get(0);
        JavaType type2 = (JavaType)types.get(1);
        Type reduction = this.leastContainingTypeArgument(type1, type2);
        ArrayList reducedList = Lists.newArrayList((Object[])new Type[]{reduction});
        reducedList.addAll(types.subList(2, types.size()));
        return this.leastContainingParameterization(reducedList);
    }

    private Type leastContainingTypeArgument(JavaType type1, JavaType type2) {
        Preconditions.checkArgument((type1.isTagged(18) && type2.isTagged(18) ? 1 : 0) != 0);
        TypeSubstitution typeSubstitution1 = ((ParametrizedTypeJavaType)type1).typeSubstitution;
        TypeSubstitution typeSubstitution2 = ((ParametrizedTypeJavaType)type2).typeSubstitution;
        TypeSubstitution newTypeSubstitution = new TypeSubstitution();
        for (TypeVariableJavaType typeVar : typeSubstitution1.typeVariables()) {
            JavaType subs1 = typeSubstitution1.substitutedType(typeVar);
            JavaType subs2 = typeSubstitution2.substitutedType(typeVar);
            JavaType newSubs = this.getNewTypeArgumentType(subs1, subs2);
            newTypeSubstitution.add(typeVar, newSubs);
        }
        return this.parametrizedTypeCache.getParametrizedTypeType(type1.symbol, newTypeSubstitution);
    }

    private JavaType getNewTypeArgumentType(JavaType type1, JavaType type2) {
        JavaType result;
        boolean isWildcard1 = type1.isTagged(16);
        boolean isWildcard2 = type2.isTagged(16);
        if (type1.equals(type2)) {
            result = type1;
        } else if (isWildcard1 && isWildcard2) {
            result = this.lctaBothWildcards((WildCardType)type1, (WildCardType)type2);
        } else if (isWildcard1 ^ isWildcard2) {
            JavaType rawType = isWildcard1 ? type2 : type1;
            WildCardType wildcardType = (WildCardType)(isWildcard1 ? type1 : type2);
            result = this.lctaOneWildcard(rawType, wildcardType);
        } else {
            result = this.lctaNoWildcard(type1, type2);
        }
        return result;
    }

    private JavaType lctaOneWildcard(JavaType rawType, WildCardType wildcardType) {
        if (wildcardType.boundType == WildCardType.BoundType.SUPER) {
            JavaType glb = (JavaType)LeastUpperBound.greatestLowerBound(Lists.newArrayList((Object[])new Type[]{rawType, wildcardType.bound}));
            return this.parametrizedTypeCache.getWildcardType(glb, WildCardType.BoundType.SUPER);
        }
        JavaType lub = (JavaType)this.cachedLeastUpperBound(Sets.newHashSet((Object[])new Type[]{rawType, wildcardType.bound}));
        return this.parametrizedTypeCache.getWildcardType(lub, WildCardType.BoundType.EXTENDS);
    }

    private JavaType lctaBothWildcards(WildCardType type1, WildCardType type2) {
        if (type1.boundType == WildCardType.BoundType.SUPER && type2.boundType == WildCardType.BoundType.SUPER) {
            JavaType glb = (JavaType)LeastUpperBound.greatestLowerBound(Lists.newArrayList((Object[])new Type[]{type1.bound, type2.bound}));
            return this.parametrizedTypeCache.getWildcardType(glb, WildCardType.BoundType.SUPER);
        }
        if (type1.boundType == WildCardType.BoundType.EXTENDS && type2.boundType == WildCardType.BoundType.EXTENDS) {
            JavaType lub = (JavaType)this.cachedLeastUpperBound(Sets.newHashSet((Object[])new Type[]{type1.bound, type2.bound}));
            return this.parametrizedTypeCache.getWildcardType(lub, WildCardType.BoundType.EXTENDS);
        }
        if (type1.bound.equals(type2.bound)) {
            return type1.bound;
        }
        return this.symbols.unboundedWildcard;
    }

    private JavaType lctaNoWildcard(JavaType type1, JavaType type2) {
        JavaType lub = (JavaType)this.cachedLeastUpperBound(Sets.newHashSet((Object[])new Type[]{type1, type2}));
        return this.parametrizedTypeCache.getWildcardType(lub, WildCardType.BoundType.EXTENDS);
    }

    private static Type greatestLowerBound(List<Type> types) {
        return types.iterator().next();
    }
}

